/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.sling;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.wrappers.ResourceResolverWrapper;
import org.apache.sling.spi.resource.provider.ResolveContext;
import org.apache.sling.spi.resource.provider.ResourceContext;
import org.apache.sling.spi.resource.provider.ResourceProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class RRMockResourceResolverWrapper
extends ResourceResolverWrapper
implements ResolveContext {
    private final ConcurrentMap<String, ResourceProvider> resourceProviders;

    RRMockResourceResolverWrapper(ResourceResolver delegate, ConcurrentMap<String, ResourceProvider> resourceProviders) {
        super(delegate);
        this.resourceProviders = resourceProviders;
    }

    public Resource getResource(@NotNull String path) {
        ResourceProvider resourceProvider = this.getMatchingResourceProvider(path);
        if (resourceProvider != null) {
            return resourceProvider.getResource((ResolveContext)this, path, ResourceContext.EMPTY_CONTEXT, null);
        }
        return super.getResource(path);
    }

    @NotNull
    public Iterator<Resource> listChildren(@NotNull Resource parent) {
        ResourceProvider resourceProvider = this.getMatchingResourceProvider(parent.getPath());
        if (resourceProvider != null) {
            Iterator result = resourceProvider.listChildren((ResolveContext)this, parent);
            if (result == null) {
                return Collections.emptyIterator();
            }
            return result;
        }
        return super.listChildren(parent);
    }

    private ResourceProvider getMatchingResourceProvider(String path) {
        if (this.resourceProviders.isEmpty()) {
            return null;
        }
        String normalizedPath = ResourceUtil.normalize((String)path);
        if (!StringUtils.startsWith((CharSequence)normalizedPath, (CharSequence)"/")) {
            return null;
        }
        return this.getMatchingResourceProviderRecursively(normalizedPath);
    }

    private ResourceProvider getMatchingResourceProviderRecursively(String path) {
        ResourceProvider provider = (ResourceProvider)this.resourceProviders.get(path);
        if (provider != null) {
            return provider;
        }
        String parentPath = ResourceUtil.getParent((String)path);
        if (parentPath != null) {
            return this.getMatchingResourceProviderRecursively(parentPath);
        }
        return null;
    }

    @NotNull
    public ResourceResolver getResourceResolver() {
        return this;
    }

    @Nullable
    public Object getProviderState() {
        return null;
    }

    @Nullable
    public ResolveContext getParentResolveContext() {
        return null;
    }

    @Nullable
    public ResourceProvider getParentResourceProvider() {
        return null;
    }
}

