/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.sling.loader;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.Iterator;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.testing.mock.sling.ResourceResolverType;
import org.apache.sling.testing.mock.sling.junit.SlingContext;
import org.apache.sling.testing.mock.sling.loader.AbstractContentLoaderBinaryTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public abstract class AbstractContentLoaderFolderJsonTest {
    @Rule
    public SlingContext context = new SlingContext(this.getResourceResolverType());
    protected String path;

    protected abstract ResourceResolverType getResourceResolverType();

    @Before
    public void setUp() {
        this.path = this.context.uniqueRoot().content();
        this.context.load().folderJson("src/test/resources/json-import-samples", this.path + "/mount");
    }

    @After
    public final void tearDown() throws Exception {
        Assert.assertFalse((boolean)this.context.resourceResolver().hasChanges());
    }

    @Test
    public void testContentResourceType() {
        Resource resource = this.context.resourceResolver().getResource(this.path + "/mount/content/jcr:content");
        Assert.assertEquals((Object)"sample/components/homepage", (Object)resource.getResourceType());
    }

    @Test
    public void testContentListChildren() {
        Resource resource = this.context.resourceResolver().getResource(this.path + "/mount/content");
        ImmutableList result = ImmutableList.copyOf((Iterator)resource.listChildren());
        Assert.assertEquals((Object)"jcr:content", (Object)((Resource)result.get(0)).getName());
        Assert.assertEquals((Object)"toolbar", (Object)((Resource)result.get(1)).getName());
    }

    @Test
    public void testDamResourceType() {
        Resource resource = this.context.resourceResolver().getResource(this.path + "/mount/dam/portraits/scott_reynolds.jpg");
        Assert.assertEquals((Object)"dam:Asset", (Object)resource.getResourceType());
    }

    @Test
    public void testBinaryResource() throws IOException {
        Resource fileResource = this.context.resourceResolver().getResource(this.path + "/mount/binary/sample-image.gif");
        AbstractContentLoaderBinaryTest.assertSampleImageFileSize(fileResource);
    }
}

