/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.sling.loader;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import org.apache.commons.io.IOUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.testing.mock.sling.ResourceResolverType;
import org.apache.sling.testing.mock.sling.junit.SlingContext;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public abstract class AbstractContentLoaderFolderFileVaultXmlTest {
    @Rule
    public SlingContext context = new SlingContext(this.getResourceResolverType());
    protected String path;

    protected abstract ResourceResolverType getResourceResolverType();

    @Before
    public void setUp() {
        this.path = "/content";
        this.context.load().folderFileVaultXml("src/test/resources/xml-jcr-import-samples", this.path);
    }

    @After
    public final void tearDown() throws Exception {
        Assert.assertFalse((boolean)this.context.resourceResolver().hasChanges());
    }

    @Test
    public void testContentResourceType() {
        Resource resource = this.context.resourceResolver().getResource(this.path + "/samples/en/jcr:content");
        Assert.assertEquals((Object)"samples/sample-app/components/content/page/homepage", (Object)resource.getResourceType());
    }

    @Test
    public void testContentListChildren() {
        Resource resource = this.context.resourceResolver().getResource(this.path + "/samples/en");
        ImmutableList result = ImmutableList.copyOf((Iterator)resource.listChildren());
        Assert.assertEquals((Object)"jcr:content", (Object)((Resource)result.get(0)).getName());
        Assert.assertEquals((Object)"tools", (Object)((Resource)result.get(1)).getName());
    }

    @Test
    public void testDamResourceType() {
        Resource resource = this.context.resourceResolver().getResource(this.path + "/dam/talk.png/jcr:content");
        Assert.assertEquals((Object)"app:AssetContent", (Object)resource.getResourceType());
    }

    @Test
    public void testBinaryResource() throws IOException {
        Resource fileResource = this.context.resourceResolver().getResource(this.path + "/dam/talk.png/jcr:content/renditions/original");
        try (InputStream is = (InputStream)fileResource.adaptTo(InputStream.class);){
            Assert.assertNotNull((String)("InputSteam is null for " + fileResource.getPath()), (Object)is);
            byte[] binaryData = IOUtils.toByteArray((InputStream)is);
            Assert.assertEquals((long)8668L, (long)binaryData.length);
        }
    }
}

