/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.sling;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Locale;
import java.util.Map;
import org.apache.sling.testing.mock.sling.MockResourceBundle;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MockResourceBundleTest {
    private static final String MY_NAME = "my-name";
    private MockResourceBundle underTest;

    @Before
    public void setUp() {
        this.underTest = new MockResourceBundle(MY_NAME, Locale.US);
        Assert.assertEquals((Object)MY_NAME, (Object)this.underTest.getBaseName());
        Assert.assertEquals((Object)Locale.US, (Object)this.underTest.getLocale());
    }

    @Test
    public void testEmpty() {
        Assert.assertEquals((Object)"unknown", (Object)this.underTest.getString("unknown"));
        Assert.assertEquals((Object)ImmutableSet.of(), (Object)this.underTest.keySet());
        Assert.assertFalse((boolean)this.underTest.getKeys().hasMoreElements());
    }

    @Test
    public void testWithMappings() {
        this.underTest.put("key1", "value1");
        this.underTest.putAll((Map)ImmutableMap.of((Object)"key2", (Object)"value2", (Object)"key3", (Object)"value3"));
        Assert.assertEquals((Object)"value1", (Object)this.underTest.getString("key1"));
        Assert.assertEquals((Object)"value2", (Object)this.underTest.getString("key2"));
        Assert.assertEquals((Object)"value3", (Object)this.underTest.getString("key3"));
        Assert.assertEquals((Object)ImmutableSet.of((Object)"key1", (Object)"key2", (Object)"key3"), (Object)this.underTest.keySet());
        Assert.assertTrue((boolean)this.underTest.getKeys().hasMoreElements());
    }
}

