/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.sling.context;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.testing.mock.osgi.ManifestScanner;
import org.apache.sling.testing.mock.osgi.MockOsgi;
import org.jetbrains.annotations.NotNull;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;

final class ModelAdapterFactoryUtil {
    @NotNull
    private static final String PACKAGE_HEADER = "Sling-Model-Packages";
    @NotNull
    private static final String CLASSES_HEADER = "Sling-Model-Classes";
    @NotNull
    private static final @NotNull String @NotNull [] MODELS_PACKAGES_FROM_MANIFEST;
    @NotNull
    private static final @NotNull String @NotNull [] MODELS_CLASSES_FROM_MANIFEST;
    @NotNull
    private static final ConcurrentMap<String, List<URL>> MODEL_URLS_FOR_PACKAGES;
    @NotNull
    private static final ConcurrentMap<String, List<URL>> MODEL_URLS_FOR_CLASSES;

    private ModelAdapterFactoryUtil() {
    }

    @NotNull
    private static @NotNull String @NotNull [] toArray(@NotNull Collection<String> values) {
        return values.toArray(new String[values.size()]);
    }

    public static void addModelsForPackages(@NotNull BundleContext bundleContext, String ... packageNames) {
        RegisterModelsBundle bundle = new RegisterModelsBundle(bundleContext, 32, packageNames, null);
        BundleEvent event = new BundleEvent(2, (Bundle)bundle);
        MockOsgi.sendBundleEvent((BundleContext)bundleContext, (BundleEvent)event);
    }

    public static void addModelsForClasses(@NotNull BundleContext bundleContext, String ... classNames) {
        RegisterModelsBundle bundle = new RegisterModelsBundle(bundleContext, 32, null, classNames);
        BundleEvent event = new BundleEvent(2, (Bundle)bundle);
        MockOsgi.sendBundleEvent((BundleContext)bundleContext, (BundleEvent)event);
    }

    public static void addModelsForClasses(@NotNull BundleContext bundleContext, Class ... classes) {
        String[] classNames = new String[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            classNames[i] = classes[i].getName();
        }
        ModelAdapterFactoryUtil.addModelsForClasses(bundleContext, classNames);
    }

    public static void addModelsForManifestEntries(@NotNull BundleContext bundleContext) {
        if (MODELS_PACKAGES_FROM_MANIFEST.length > 0) {
            ModelAdapterFactoryUtil.addModelsForPackages(bundleContext, MODELS_PACKAGES_FROM_MANIFEST);
        }
        if (MODELS_CLASSES_FROM_MANIFEST.length > 0) {
            ModelAdapterFactoryUtil.addModelsForClasses(bundleContext, MODELS_CLASSES_FROM_MANIFEST);
        }
    }

    private static Collection<URL> getModelClassUrlsForPackages(String packageNames) {
        ArrayList<URL> urls = (ArrayList<URL>)MODEL_URLS_FOR_PACKAGES.get(packageNames);
        if (urls == null) {
            urls = new ArrayList<URL>();
            ConfigurationBuilder reflectionsConfig = new ConfigurationBuilder();
            Stream.of(StringUtils.split((String)packageNames, (String)",")).forEach(packageName -> reflectionsConfig.addUrls(ClasspathHelper.forPackage((String)(packageName + "."), (ClassLoader[])new ClassLoader[0])));
            Reflections reflections = new Reflections((Configuration)reflectionsConfig);
            Set classes = reflections.getTypesAnnotatedWith(Model.class);
            for (Class clazz : classes) {
                urls.add(ModelAdapterFactoryUtil.classToUrl(clazz));
            }
            MODEL_URLS_FOR_PACKAGES.putIfAbsent(packageNames, urls);
        }
        return urls;
    }

    private static Collection<URL> getModelClassUrlsForClasses(String classNames) {
        ArrayList<URL> urls = (ArrayList<URL>)MODEL_URLS_FOR_CLASSES.get(classNames);
        if (urls == null) {
            String[] packageNameArray;
            urls = new ArrayList<URL>();
            for (String className : packageNameArray = StringUtils.split((String)classNames, (String)",")) {
                try {
                    Class<?> clazz = Class.forName(className);
                    if (!clazz.isAnnotationPresent(Model.class)) continue;
                    urls.add(ModelAdapterFactoryUtil.classToUrl(clazz));
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            MODEL_URLS_FOR_CLASSES.putIfAbsent(classNames, urls);
        }
        return urls;
    }

    private static URL classToUrl(Class clazz) {
        try {
            return new URL("file:/" + clazz.getName().replace('.', '/') + ".class");
        }
        catch (MalformedURLException ex) {
            throw new RuntimeException("Malformed URL.", ex);
        }
    }

    static {
        MODEL_URLS_FOR_PACKAGES = new ConcurrentHashMap<String, List<URL>>();
        MODEL_URLS_FOR_CLASSES = new ConcurrentHashMap<String, List<URL>>();
        Reflections.log = null;
        MODELS_PACKAGES_FROM_MANIFEST = ModelAdapterFactoryUtil.toArray(ManifestScanner.getValues((String)PACKAGE_HEADER));
        MODELS_CLASSES_FROM_MANIFEST = ModelAdapterFactoryUtil.toArray(ManifestScanner.getValues((String)CLASSES_HEADER));
    }

    private static class RegisterModelsBundle
    implements Bundle {
        private static final String MAGIC_STRING = "MOCKS-YOU-KNOW-WHAT-TO-SCAN";
        private final BundleContext bundleContext;
        private final int state;
        private final String packageNames;
        private final String classNames;

        public RegisterModelsBundle(BundleContext bundleContext, int state, String[] packageNames, String[] classNames) {
            this.bundleContext = bundleContext;
            this.state = state;
            this.packageNames = this.normalizeValueList(packageNames);
            this.classNames = this.normalizeValueList(classNames);
        }

        private String normalizeValueList(String[] values) {
            if (values == null || values.length == 0) {
                return null;
            }
            return StringUtils.join((Object[])values, (String)",");
        }

        public int getState() {
            return this.state;
        }

        public Dictionary<String, String> getHeaders() {
            Hashtable<String, String> headers = new Hashtable<String, String>();
            ((Dictionary)headers).put(ModelAdapterFactoryUtil.PACKAGE_HEADER, MAGIC_STRING);
            return headers;
        }

        public Enumeration<URL> findEntries(String path, String filePattern, boolean recurse) {
            Vector urls = new Vector();
            if (this.packageNames != null) {
                urls.addAll(ModelAdapterFactoryUtil.getModelClassUrlsForPackages(this.packageNames));
            }
            if (this.classNames != null) {
                urls.addAll(ModelAdapterFactoryUtil.getModelClassUrlsForClasses(this.classNames));
            }
            return urls.elements();
        }

        public Class<?> loadClass(String name) throws ClassNotFoundException {
            return this.getClass().getClassLoader().loadClass(name);
        }

        public BundleContext getBundleContext() {
            return this.bundleContext;
        }

        public void start(int options) throws BundleException {
        }

        public void start() throws BundleException {
        }

        public void stop(int options) throws BundleException {
        }

        public void stop() throws BundleException {
        }

        public void update(InputStream input) throws BundleException {
        }

        public void update() throws BundleException {
        }

        public void uninstall() throws BundleException {
        }

        public long getBundleId() {
            return 0L;
        }

        public String getLocation() {
            return null;
        }

        public ServiceReference<?>[] getRegisteredServices() {
            return null;
        }

        public ServiceReference<?>[] getServicesInUse() {
            return null;
        }

        public boolean hasPermission(Object permission) {
            return false;
        }

        public URL getResource(String name) {
            return null;
        }

        public Dictionary<String, String> getHeaders(String locale) {
            return null;
        }

        public String getSymbolicName() {
            return null;
        }

        public Enumeration<URL> getResources(String name) throws IOException {
            return null;
        }

        public Enumeration<String> getEntryPaths(String path) {
            return null;
        }

        public URL getEntry(String path) {
            return null;
        }

        public long getLastModified() {
            return 0L;
        }

        public Map<X509Certificate, List<X509Certificate>> getSignerCertificates(int signersType) {
            return null;
        }

        public Version getVersion() {
            return null;
        }

        public int compareTo(Bundle o) {
            return 0;
        }

        public <A> A adapt(Class<A> type) {
            return null;
        }

        public File getDataFile(String filename) {
            return null;
        }
    }
}

