/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.sling.loader;

import java.io.IOException;
import java.io.InputStream;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.commons.mime.MimeTypeService;
import org.apache.sling.contentparser.api.ContentHandler;
import org.apache.sling.contentparser.api.ContentParser;
import org.apache.sling.contentparser.api.ParserOptions;
import org.apache.sling.contentparser.json.JSONParserFeature;
import org.apache.sling.contentparser.json.JSONParserOptions;
import org.apache.sling.contentparser.json.internal.JSONContentParser;
import org.apache.sling.testing.mock.sling.ResourceResolverType;
import org.apache.sling.testing.mock.sling.builder.ImmutableValueMap;
import org.apache.sling.testing.mock.sling.loader.LoaderContentHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public final class ContentLoader {
    private static final String CONTENTTYPE_OCTET_STREAM = "application/octet-stream";
    private static final Set<String> SHARED_IGNORED_NAMES = Stream.of("jcr:baseVersion", "jcr:predecessors", "jcr:successors", "jcr:versionHistory", "jcr:checkedOut", "jcr:isCheckedOut", "rep:policy").collect(Collectors.toSet());
    private static final Set<String> MOCK_IGNORED_NAMES = Stream.concat(SHARED_IGNORED_NAMES.stream(), Stream.of("jcr:mixinTypes")).collect(Collectors.toSet());
    private static final Set<String> OAK_IGNORED_NAMES = Stream.concat(SHARED_IGNORED_NAMES.stream(), Stream.of("jcr:uuid", "jcr:created")).collect(Collectors.toSet());
    private final ResourceResolver resourceResolver;
    private final BundleContext bundleContext;
    private final boolean autoCommit;
    private final Set<String> ignoredNames;
    private final ContentParser jsonParser;
    private final ParserOptions jsonParserOptions;

    public ContentLoader(@NotNull ResourceResolver resourceResolver) {
        this(resourceResolver, null);
    }

    public ContentLoader(@NotNull ResourceResolver resourceResolver, @Nullable BundleContext bundleContext) {
        this(resourceResolver, bundleContext, true);
    }

    public ContentLoader(@NotNull ResourceResolver resourceResolver, @Nullable BundleContext bundleContext, boolean autoCommit) {
        this(resourceResolver, bundleContext, autoCommit, null);
    }

    public ContentLoader(@NotNull ResourceResolver resourceResolver, @Nullable BundleContext bundleContext, boolean autoCommit, @Nullable ResourceResolverType resourceResolverType) {
        this.resourceResolver = resourceResolver;
        this.bundleContext = bundleContext;
        this.autoCommit = autoCommit;
        this.ignoredNames = this.getIgnoredNamesForResourceResolverType(resourceResolverType);
        this.jsonParserOptions = new JSONParserOptions().withFeatures(EnumSet.of(JSONParserFeature.COMMENTS, JSONParserFeature.QUOTE_TICK)).detectCalendarValues(true).ignorePropertyNames(this.ignoredNames).ignoreResourceNames(this.ignoredNames);
        this.jsonParser = new JSONContentParser();
    }

    private final Set<String> getIgnoredNamesForResourceResolverType(ResourceResolverType resourceResolverType) {
        if (resourceResolverType == null || resourceResolverType == ResourceResolverType.JCR_OAK) {
            return OAK_IGNORED_NAMES;
        }
        return MOCK_IGNORED_NAMES;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Resource json(@NotNull String classpathResource, @NotNull Resource parentResource, @NotNull String childName) {
        InputStream is = ContentLoader.class.getResourceAsStream(classpathResource);
        if (is == null) {
            throw new IllegalArgumentException("Classpath resource not found: " + classpathResource);
        }
        try {
            Resource resource = this.json(is, parentResource, childName);
            return resource;
        }
        finally {
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Resource json(@NotNull String classpathResource, @NotNull String destPath) {
        InputStream is = ContentLoader.class.getResourceAsStream(classpathResource);
        if (is == null) {
            throw new IllegalArgumentException("Classpath resource not found: " + classpathResource);
        }
        try {
            Resource resource = this.json(is, destPath);
            return resource;
        }
        finally {
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
    }

    @NotNull
    public Resource json(@NotNull InputStream inputStream, @NotNull Resource parentResource, @NotNull String childName) {
        return this.json(inputStream, parentResource.getPath() + "/" + childName);
    }

    @NotNull
    public Resource json(@NotNull InputStream inputStream, @NotNull String destPath) {
        try {
            String parentPath = ResourceUtil.getParent((String)destPath);
            String childName = ResourceUtil.getName((String)destPath);
            if (parentPath == null) {
                throw new IllegalArgumentException("Path has no parent: " + destPath);
            }
            Resource parentResource = this.resourceResolver.getResource(parentPath);
            if (parentResource == null) {
                parentResource = this.createResourceHierarchy(parentPath);
            }
            if (parentResource.getChild(childName) != null) {
                throw new IllegalArgumentException("Resource does already exist: " + destPath);
            }
            LoaderContentHandler contentHandler = new LoaderContentHandler(destPath, this.resourceResolver);
            this.jsonParser.parse((ContentHandler)contentHandler, inputStream, this.jsonParserOptions);
            if (this.autoCommit) {
                this.resourceResolver.commit();
            }
            return this.resourceResolver.getResource(destPath);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    @NotNull
    private Resource createResourceHierarchy(@NotNull String path) {
        String parentPath = ResourceUtil.getParent((String)path);
        if (parentPath == null) {
            throw new IllegalArgumentException("Path has no parent: " + path);
        }
        Resource parentResource = this.resourceResolver.getResource(parentPath);
        if (parentResource == null) {
            parentResource = this.createResourceHierarchy(parentPath);
        }
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("jcr:primaryType", "nt:unstructured");
        try {
            return this.resourceResolver.create(parentResource, ResourceUtil.getName((String)path), props);
        }
        catch (PersistenceException ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Resource binaryFile(@NotNull String classpathResource, @NotNull String path) {
        InputStream is = ContentLoader.class.getResourceAsStream(classpathResource);
        if (is == null) {
            throw new IllegalArgumentException("Classpath resource not found: " + classpathResource);
        }
        try {
            Resource resource = this.binaryFile(is, path, this.detectMimeTypeFromNames(classpathResource, path));
            return resource;
        }
        finally {
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Resource binaryFile(@NotNull String classpathResource, @NotNull String path, @NotNull String mimeType) {
        InputStream is = ContentLoader.class.getResourceAsStream(classpathResource);
        if (is == null) {
            throw new IllegalArgumentException("Classpath resource not found: " + classpathResource);
        }
        try {
            Resource resource = this.binaryFile(is, path, mimeType);
            return resource;
        }
        finally {
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
    }

    @NotNull
    public Resource binaryFile(@NotNull InputStream inputStream, @NotNull String path) {
        return this.binaryFile(inputStream, path, this.detectMimeTypeFromNames(path));
    }

    @NotNull
    public Resource binaryFile(@NotNull InputStream inputStream, @NotNull String path, @NotNull String mimeType) {
        String parentPath = ResourceUtil.getParent((String)path, (int)1);
        String name = ResourceUtil.getName((String)path);
        if (parentPath == null) {
            throw new IllegalArgumentException("Path has no parent: " + path);
        }
        Resource parentResource = this.resourceResolver.getResource(parentPath);
        if (parentResource == null) {
            parentResource = this.createResourceHierarchy(parentPath);
        }
        return this.binaryFile(inputStream, parentResource, name, mimeType);
    }

    @NotNull
    public Resource binaryFile(@NotNull InputStream inputStream, @NotNull Resource parentResource, @NotNull String name) {
        return this.binaryFile(inputStream, parentResource, name, this.detectMimeTypeFromNames(name));
    }

    @NotNull
    public Resource binaryFile(@NotNull InputStream inputStream, @NotNull Resource parentResource, @NotNull String name, @NotNull String mimeType) {
        try {
            Resource file = this.resourceResolver.create(parentResource, name, (Map)((Object)ImmutableValueMap.of("jcr:primaryType", "nt:file")));
            this.resourceResolver.create(file, "jcr:content", (Map)((Object)ImmutableValueMap.of("jcr:primaryType", "nt:resource", "jcr:data", inputStream, "jcr:mimeType", mimeType)));
            if (this.autoCommit) {
                this.resourceResolver.commit();
            }
            return file;
        }
        catch (PersistenceException ex) {
            throw new RuntimeException("Unable to create resource at " + parentResource.getPath() + "/" + name, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Resource binaryResource(@NotNull String classpathResource, @NotNull String path) {
        InputStream is = ContentLoader.class.getResourceAsStream(classpathResource);
        if (is == null) {
            throw new IllegalArgumentException("Classpath resource not found: " + classpathResource);
        }
        try {
            Resource resource = this.binaryResource(is, path, this.detectMimeTypeFromNames(classpathResource, path));
            return resource;
        }
        finally {
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Resource binaryResource(@NotNull String classpathResource, @NotNull String path, @NotNull String mimeType) {
        InputStream is = ContentLoader.class.getResourceAsStream(classpathResource);
        if (is == null) {
            throw new IllegalArgumentException("Classpath resource not found: " + classpathResource);
        }
        try {
            Resource resource = this.binaryResource(is, path, mimeType);
            return resource;
        }
        finally {
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
    }

    @NotNull
    public Resource binaryResource(@NotNull InputStream inputStream, @NotNull String path) {
        return this.binaryResource(inputStream, path, this.detectMimeTypeFromNames(path));
    }

    @NotNull
    public Resource binaryResource(@NotNull InputStream inputStream, @NotNull String path, @NotNull String mimeType) {
        String parentPath = ResourceUtil.getParent((String)path, (int)1);
        String name = ResourceUtil.getName((String)path);
        if (parentPath == null) {
            throw new IllegalArgumentException("Path has no parent: " + path);
        }
        Resource parentResource = this.resourceResolver.getResource(parentPath);
        if (parentResource == null) {
            parentResource = this.createResourceHierarchy(parentPath);
        }
        return this.binaryResource(inputStream, parentResource, name, mimeType);
    }

    @NotNull
    public Resource binaryResource(@NotNull InputStream inputStream, @NotNull Resource parentResource, @NotNull String name) {
        return this.binaryResource(inputStream, parentResource, name, this.detectMimeTypeFromNames(name));
    }

    @NotNull
    public Resource binaryResource(@NotNull InputStream inputStream, @NotNull Resource parentResource, @NotNull String name, @NotNull String mimeType) {
        try {
            Resource resource = this.resourceResolver.create(parentResource, name, (Map)((Object)ImmutableValueMap.of("jcr:primaryType", "nt:resource", "jcr:data", inputStream, "jcr:mimeType", mimeType)));
            if (this.autoCommit) {
                this.resourceResolver.commit();
            }
            return resource;
        }
        catch (PersistenceException ex) {
            throw new RuntimeException("Unable to create resource at " + parentResource.getPath() + "/" + name, ex);
        }
    }

    @NotNull
    private String detectMimeTypeFromNames(String ... names) {
        String mimeType = null;
        for (String name : names) {
            ServiceReference ref;
            String fileExtension = StringUtils.substringAfterLast((String)name, (String)".");
            if (this.bundleContext == null || !StringUtils.isNotEmpty((CharSequence)fileExtension) || (ref = this.bundleContext.getServiceReference(MimeTypeService.class)) == null) continue;
            MimeTypeService mimeTypeService = (MimeTypeService)this.bundleContext.getService(ref);
            mimeType = mimeTypeService.getMimeType(fileExtension);
            break;
        }
        return StringUtils.defaultString(mimeType, (String)CONTENTTYPE_OCTET_STREAM);
    }
}

