/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.sling.loader;

import java.io.ByteArrayInputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.jcr.contentparser.ContentHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class LoaderContentHandler
implements ContentHandler {
    private static final String JCR_DATA_PLACEHOLDER = ":jcr:data";
    @NotNull
    private final String rootPath;
    @NotNull
    private final ResourceResolver resourceResolver;

    public LoaderContentHandler(@NotNull String rootPath, @NotNull ResourceResolver resourceResolver) {
        this.rootPath = rootPath;
        this.resourceResolver = resourceResolver;
    }

    public void resource(String path, Map<String, Object> properties) {
        String fullPath = this.rootPath;
        if (!StringUtils.equals((CharSequence)path, (CharSequence)"/")) {
            fullPath = fullPath + path;
        }
        String parentPath = ResourceUtil.getParent((String)fullPath);
        String name = ResourceUtil.getName((String)fullPath);
        if (parentPath == null) {
            throw new IllegalArgumentException("Path has no parent: " + fullPath);
        }
        Resource parentResource = this.resourceResolver.getResource(parentPath);
        if (parentResource == null) {
            throw new RuntimeException("Parent resource '" + parentPath + "' not found.");
        }
        try {
            this.createResource(parentResource, name, properties);
        }
        catch (PersistenceException ex) {
            throw new RuntimeException("Unable to create resource at '" + fullPath + "'.", ex);
        }
    }

    private Resource createResource(@NotNull Resource parentResource, @NotNull String childName, @Nullable Map<String, Object> content) throws PersistenceException {
        ModifiableValueMap valueMap;
        boolean hasJcrData = false;
        HashMap<String, Object> props = new HashMap<String, Object>();
        if (content != null) {
            for (Map.Entry<String, Object> entry : content.entrySet()) {
                String name = entry.getKey();
                if (StringUtils.equals((CharSequence)name, (CharSequence)JCR_DATA_PLACEHOLDER)) {
                    hasJcrData = true;
                    continue;
                }
                props.put(name, entry.getValue());
            }
        }
        Resource resource = this.resourceResolver.create(parentResource, childName, props);
        if (hasJcrData && (valueMap = (ModifiableValueMap)resource.adaptTo(ModifiableValueMap.class)) != null) {
            valueMap.put((Object)"jcr:data", (Object)new ByteArrayInputStream(new byte[0]));
        }
        return resource;
    }
}

