/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.sling.builder;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.testing.mock.osgi.MapUtil;
import org.jetbrains.annotations.NotNull;

public class ContentBuilder {
    static final String DUMMY_TEMPLATE = "/apps/sample/templates/template1";
    protected final ResourceResolver resourceResolver;

    public ContentBuilder(@NotNull ResourceResolver resourceResolver) {
        this.resourceResolver = resourceResolver;
    }

    @NotNull
    public final Resource resource(@NotNull String path) {
        return this.resource(path, (Map<String, Object>)ValueMap.EMPTY);
    }

    @NotNull
    public final Resource resource(@NotNull String path, @NotNull Map<String, Object> properties) {
        Resource newResource;
        Map<String, Object> propertiesWihtoutChildren;
        String parentPath = ResourceUtil.getParent((String)path);
        if (parentPath == null) {
            throw new IllegalArgumentException("Path has no parent: " + path);
        }
        Map<String, Map<String, Object>> children = this.getChildMaps(properties);
        if (!children.isEmpty()) {
            propertiesWihtoutChildren = new HashMap<String, Object>();
            for (Map.Entry<String, Object> entry : properties.entrySet()) {
                if (children.containsKey(entry.getKey())) continue;
                propertiesWihtoutChildren.put(entry.getKey(), entry.getValue());
            }
        } else {
            propertiesWihtoutChildren = properties;
        }
        Resource parentResource = this.ensureResourceExists(parentPath);
        String name = ResourceUtil.getName((String)path);
        try {
            newResource = this.resourceResolver.create(parentResource, name, propertiesWihtoutChildren);
        }
        catch (PersistenceException ex) {
            throw new RuntimeException("Unable to create resource at " + path, ex);
        }
        for (Map.Entry<String, Map<String, Object>> entry : children.entrySet()) {
            this.resource(newResource, entry.getKey(), entry.getValue());
        }
        return newResource;
    }

    private Map<String, Map<String, Object>> getChildMaps(Map<String, Object> properties) {
        LinkedHashMap<String, Map<String, Object>> result = new LinkedHashMap<String, Map<String, Object>>();
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            if (!(entry.getValue() instanceof Map)) continue;
            result.put(entry.getKey(), (Map)entry.getValue());
        }
        return result;
    }

    @NotNull
    public final Resource resource(@NotNull String path, Object ... properties) {
        return this.resource(path, MapUtil.toMap((Object[])properties));
    }

    @NotNull
    public final Resource resource(@NotNull Resource resource, @NotNull String name) {
        return this.resource(resource, name, (Map<String, Object>)ValueMap.EMPTY);
    }

    @NotNull
    public final Resource resource(@NotNull Resource resource, @NotNull String name, @NotNull Map<String, Object> properties) {
        String path = resource.getPath() + "/" + StringUtils.stripStart((String)name, (String)"/");
        return this.resource(path, properties);
    }

    @NotNull
    public final Resource resource(@NotNull Resource resource, @NotNull String name, Object ... properties) {
        return this.resource(resource, name, MapUtil.toMap((Object[])properties));
    }

    @NotNull
    protected final Resource ensureResourceExists(@NotNull String path) {
        if (StringUtils.isEmpty((CharSequence)path) || StringUtils.equals((CharSequence)path, (CharSequence)"/")) {
            return this.resourceResolver.getResource("/");
        }
        Resource resource = this.resourceResolver.getResource(path);
        if (resource != null) {
            return resource;
        }
        String parentPath = ResourceUtil.getParent((String)path);
        if (parentPath == null) {
            throw new IllegalArgumentException("Path has no parent: " + path);
        }
        String name = ResourceUtil.getName((String)path);
        Resource parentResource = this.ensureResourceExists(parentPath);
        try {
            resource = this.resourceResolver.create(parentResource, name, (Map)ImmutableMap.builder().put((Object)"jcr:primaryType", (Object)"nt:unstructured").build());
            this.resourceResolver.commit();
            return resource;
        }
        catch (PersistenceException ex) {
            throw new RuntimeException("Unable to create resource at " + path, ex);
        }
    }
}

