/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.sling.resource;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.testing.mock.sling.ResourceResolverType;
import org.apache.sling.testing.mock.sling.builder.ContentBuilder;
import org.apache.sling.testing.mock.sling.junit.SlingContext;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public abstract class AbstractSlingCrudResourceResolverTest {
    @Rule
    public SlingContext context = new SlingContext(this.getResourceResolverType());
    private static final String STRING_VALUE = "value1";
    private static final String[] STRING_ARRAY_VALUE = new String[]{"value1", "value2"};
    private static final int INTEGER_VALUE = 25;
    private static final long LONG_VALUE = 250L;
    private static final double DOUBLE_VALUE = 3.555;
    private static final BigDecimal BIGDECIMAL_VALUE = new BigDecimal("12345.678");
    private static final boolean BOOLEAN_VALUE = true;
    private static final Date DATE_VALUE = new Date(10000L);
    private static final Calendar CALENDAR_VALUE = Calendar.getInstance();
    private static final byte[] BINARY_VALUE = new byte[]{1, 2, 3, 4, 5, 6};
    protected Resource testRoot;

    protected abstract ResourceResolverType getResourceResolverType();

    @Before
    public final void setUp() throws IOException {
        Resource rootNode = this.getTestRootResource();
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("jcr:primaryType", "nt:unstructured");
        props.put("stringProp", STRING_VALUE);
        props.put("stringArrayProp", STRING_ARRAY_VALUE);
        props.put("integerProp", 25);
        props.put("longProp", 250L);
        props.put("doubleProp", 3.555);
        props.put("bigDecimalProp", BIGDECIMAL_VALUE);
        props.put("booleanProp", true);
        props.put("dateProp", DATE_VALUE);
        props.put("calendarProp", CALENDAR_VALUE);
        props.put("binaryProp", new ByteArrayInputStream(BINARY_VALUE));
        Resource node1 = this.context.resourceResolver().create(rootNode, "node1", props);
        this.context.resourceResolver().create(node1, "node11", (Map)ImmutableMap.builder().put((Object)"stringProp11", (Object)STRING_VALUE).build());
        this.context.resourceResolver().create(node1, "node12", (Map)ValueMap.EMPTY);
        this.context.resourceResolver().commit();
    }

    protected Resource getTestRootResource() throws PersistenceException {
        if (this.testRoot == null) {
            this.testRoot = this.context.resourceResolver().getResource(this.context.uniqueRoot().content());
        }
        return this.testRoot;
    }

    @Test
    public void testSimpleProperties() throws IOException {
        Resource resource1 = this.context.resourceResolver().getResource(this.getTestRootResource().getPath() + "/node1");
        Assert.assertNotNull((Object)resource1);
        Assert.assertEquals((Object)"node1", (Object)resource1.getName());
        ValueMap props = ResourceUtil.getValueMap((Resource)resource1);
        Assert.assertEquals((Object)STRING_VALUE, (Object)props.get("stringProp", String.class));
        Assert.assertArrayEquals((Object[])STRING_ARRAY_VALUE, (Object[])((Object[])props.get("stringArrayProp", String[].class)));
        Assert.assertEquals((Object)25, (Object)props.get("integerProp", Integer.class));
        Assert.assertEquals((Object)250L, (Object)props.get("longProp", Long.class));
        Assert.assertEquals((double)3.555, (double)((Double)props.get("doubleProp", Double.class)), (double)1.0E-4);
        Assert.assertEquals((Object)BIGDECIMAL_VALUE, (Object)props.get("bigDecimalProp", BigDecimal.class));
        Assert.assertEquals((Object)true, (Object)props.get("booleanProp", Boolean.class));
    }

    @Test
    public void testSimpleProperties_IntegerLongConversion() throws IOException {
        Resource resource1 = this.context.resourceResolver().getResource(this.getTestRootResource().getPath() + "/node1");
        ValueMap props = ResourceUtil.getValueMap((Resource)resource1);
        Assert.assertEquals((Object)250, (Object)props.get("longProp", Integer.class));
        Assert.assertEquals((Object)25L, (Object)props.get("integerProp", Long.class));
    }

    @Test
    public void testSimpleProperties_DecimalConversion() throws IOException {
        Resource resource1 = this.context.resourceResolver().getResource(this.getTestRootResource().getPath() + "/node1");
        ValueMap props = ResourceUtil.getValueMap((Resource)resource1);
        Assert.assertEquals((double)new BigDecimal(3.555).doubleValue(), (double)((BigDecimal)props.get("doubleProp", BigDecimal.class)).doubleValue(), (double)1.0E-4);
        Assert.assertEquals((double)BIGDECIMAL_VALUE.doubleValue(), (double)((Double)props.get("bigDecimalProp", Double.class)), (double)1.0E-4);
    }

    @Test
    public void testSimpleProperties_DeepPathAccess() throws IOException {
        Resource resource1 = this.context.resourceResolver().getResource(this.testRoot.getPath());
        Assert.assertNotNull((Object)resource1);
        Assert.assertEquals((Object)this.testRoot.getName(), (Object)resource1.getName());
        ValueMap props = ResourceUtil.getValueMap((Resource)resource1);
        Assert.assertEquals((Object)STRING_VALUE, (Object)props.get("node1/stringProp", String.class));
        Assert.assertArrayEquals((Object[])STRING_ARRAY_VALUE, (Object[])((Object[])props.get("node1/stringArrayProp", String[].class)));
        Assert.assertEquals((Object)25, (Object)props.get("node1/integerProp", Integer.class));
        Assert.assertEquals((Object)250L, (Object)props.get("node1/longProp", Long.class));
        Assert.assertEquals((double)3.555, (double)((Double)props.get("node1/doubleProp", Double.class)), (double)1.0E-4);
        Assert.assertEquals((Object)BIGDECIMAL_VALUE, (Object)props.get("node1/bigDecimalProp", BigDecimal.class));
        Assert.assertEquals((Object)true, (Object)props.get("node1/booleanProp", Boolean.class));
        Assert.assertEquals((Object)STRING_VALUE, (Object)props.get("node1/node11/stringProp11", String.class));
    }

    @Test
    public void testDateProperty() throws IOException {
        Resource resource1 = this.context.resourceResolver().getResource(this.getTestRootResource().getPath() + "/node1");
        ValueMap props = ResourceUtil.getValueMap((Resource)resource1);
        Assert.assertEquals((Object)DATE_VALUE, (Object)props.get("dateProp", Date.class));
    }

    @Test
    public void testDatePropertyToCalendar() throws IOException {
        Resource resource1 = this.context.resourceResolver().getResource(this.getTestRootResource().getPath() + "/node1");
        ValueMap props = ResourceUtil.getValueMap((Resource)resource1);
        Calendar calendarValue = (Calendar)props.get("dateProp", Calendar.class);
        Assert.assertNotNull((Object)calendarValue);
        Assert.assertEquals((Object)DATE_VALUE, (Object)calendarValue.getTime());
    }

    @Test
    public void testCalendarProperty() throws IOException {
        Resource resource1 = this.context.resourceResolver().getResource(this.getTestRootResource().getPath() + "/node1");
        ValueMap props = ResourceUtil.getValueMap((Resource)resource1);
        Assert.assertEquals((Object)CALENDAR_VALUE.getTime(), (Object)((Calendar)props.get("calendarProp", Calendar.class)).getTime());
    }

    @Test
    public void testCalendarPropertyToDate() throws IOException {
        Resource resource1 = this.context.resourceResolver().getResource(this.getTestRootResource().getPath() + "/node1");
        ValueMap props = ResourceUtil.getValueMap((Resource)resource1);
        Date dateValue = (Date)props.get("calendarProp", Date.class);
        Assert.assertNotNull((Object)dateValue);
        Assert.assertEquals((Object)CALENDAR_VALUE.getTime(), (Object)dateValue);
    }

    @Test
    public void testListChildren() throws IOException {
        Resource resource1 = this.context.resourceResolver().getResource(this.getTestRootResource().getPath() + "/node1");
        ImmutableList children = ImmutableList.copyOf((Iterator)resource1.listChildren());
        Assert.assertEquals((long)2L, (long)children.size());
        Assert.assertEquals((Object)"node11", (Object)((Resource)children.get(0)).getName());
        Assert.assertEquals((Object)"node12", (Object)((Resource)children.get(1)).getName());
    }

    @Test
    public void testListChildren_RootNode() throws IOException {
        Resource resource1 = this.context.resourceResolver().getResource("/");
        ArrayList children = Lists.newArrayList((Iterator)resource1.listChildren());
        Assert.assertFalse((boolean)children.isEmpty());
        Assert.assertTrue((boolean)this.containsResource(children, this.getTestRootResource().getParent()));
        children = Lists.newArrayList((Iterable)resource1.getChildren());
        Assert.assertFalse((boolean)children.isEmpty());
        Assert.assertTrue((boolean)this.containsResource(children, this.getTestRootResource().getParent()));
    }

    private boolean containsResource(List<Resource> children, Resource resource) {
        for (Resource child : children) {
            if (!StringUtils.equals((CharSequence)child.getPath(), (CharSequence)resource.getPath())) continue;
            return true;
        }
        return false;
    }

    @Test
    public void testBinaryData() throws IOException {
        Resource resource1 = this.context.resourceResolver().getResource(this.getTestRootResource().getPath() + "/node1");
        Resource binaryPropResource = resource1.getChild("binaryProp");
        InputStream is = (InputStream)binaryPropResource.adaptTo(InputStream.class);
        byte[] dataFromResource = IOUtils.toByteArray((InputStream)is);
        is.close();
        Assert.assertArrayEquals((byte[])BINARY_VALUE, (byte[])dataFromResource);
        InputStream is2 = (InputStream)ResourceUtil.getValueMap((Resource)resource1).get("binaryProp", InputStream.class);
        byte[] dataFromResource2 = IOUtils.toByteArray((InputStream)is2);
        is2.close();
        Assert.assertArrayEquals((byte[])BINARY_VALUE, (byte[])dataFromResource2);
    }

    @Test
    public void testPrimaryTypeResourceType() throws PersistenceException {
        Resource resource = this.context.resourceResolver().getResource(this.getTestRootResource().getPath() + "/node1");
        Assert.assertEquals((Object)"nt:unstructured", (Object)resource.getResourceType());
    }

    @Test
    public void testGetRootResourceByNullPath() {
        Resource rootResource = this.context.resourceResolver().resolve((String)null);
        Assert.assertNotNull((Object)rootResource);
        Assert.assertEquals((Object)"/", (Object)rootResource.getPath());
    }

    @Test
    public void testSearchPath() {
        ContentBuilder builder = new ContentBuilder(this.context.resourceResolver());
        builder.resource("/libs/any/path");
        Resource resource = this.context.resourceResolver().getResource("any/path");
        Assert.assertNotNull((Object)resource);
        Assert.assertEquals((Object)"/libs/any/path", (Object)resource.getPath());
        builder.resource("/apps/any/path");
        resource = this.context.resourceResolver().getResource("any/path");
        Assert.assertNotNull((Object)resource);
        Assert.assertEquals((Object)"/apps/any/path", (Object)resource.getPath());
    }

    @Test
    public void testPendingChangesCommit() throws PersistenceException {
        if (this.getResourceResolverType() == ResourceResolverType.JCR_MOCK) {
            return;
        }
        this.context.resourceResolver().delete(this.getTestRootResource());
        Assert.assertTrue((boolean)this.context.resourceResolver().hasChanges());
        this.context.resourceResolver().commit();
        Assert.assertFalse((boolean)this.context.resourceResolver().hasChanges());
    }

    @Test
    public void testCreateNestedResources() throws IOException {
        Resource nested = this.context.create().resource(this.getTestRootResource().getPath() + "/nested", (Map)ImmutableMap.of((Object)"prop1", (Object)STRING_VALUE, (Object)"child1", (Object)ImmutableMap.of((Object)"prop2", (Object)"value2", (Object)"child2", (Object)ImmutableMap.of((Object)"prop3", (Object)"value3"))));
        Assert.assertNotNull((Object)nested);
        Assert.assertEquals((Object)STRING_VALUE, (Object)nested.getValueMap().get("prop1", String.class));
        Resource child1 = nested.getChild("child1");
        Assert.assertNotNull((Object)child1);
        Assert.assertEquals((Object)"value2", (Object)child1.getValueMap().get("prop2", String.class));
        Resource child2 = child1.getChild("child2");
        Assert.assertNotNull((Object)child2);
        Assert.assertEquals((Object)"value3", (Object)child2.getValueMap().get("prop3", String.class));
    }
}

