/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.sling.resource;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.testing.mock.osgi.MockOsgi;
import org.apache.sling.testing.mock.sling.MockSling;
import org.apache.sling.testing.mock.sling.ResourceResolverType;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.osgi.framework.BundleContext;

public abstract class AbstractMultipleResourceResolverTest {
    private final BundleContext bundleContext = MockOsgi.newBundleContext();

    protected abstract ResourceResolverType getResourceResolverType();

    protected ResourceResolverFactory newResourceResolerFactory() {
        return MockSling.newResourceResolverFactory((ResourceResolverType)this.getResourceResolverType(), (BundleContext)this.bundleContext);
    }

    @After
    public void tearDown() {
        MockOsgi.shutdown((BundleContext)this.bundleContext);
    }

    @Test
    public void testMultipleResourceResolver() throws Exception {
        ResourceResolverFactory factory = this.newResourceResolerFactory();
        ResourceResolver resolver1 = factory.getAdministrativeResourceResolver(null);
        ResourceResolver resolver2 = factory.getAdministrativeResourceResolver(null);
        Resource root = resolver1.getResource("/");
        resolver1.create(root, "test", (Map)ImmutableMap.of());
        resolver1.commit();
        Resource testResource2 = resolver2.getResource("/test");
        Assert.assertNotNull((Object)testResource2);
        resolver2.delete(testResource2);
        resolver2.commit();
        Assert.assertNull((Object)resolver1.getResource("/test"));
    }
}

