/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.sling.loader;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.testing.mock.sling.ResourceResolverType;
import org.apache.sling.testing.mock.sling.junit.SlingContext;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public abstract class AbstractContentLoaderBinaryTest {
    private static final int SAMPLE_IMAGE_FILESIZE = 62;
    @Rule
    public SlingContext context = new SlingContext(this.getResourceResolverType());
    protected String path;

    protected abstract ResourceResolverType getResourceResolverType();

    @Before
    public void setUp() {
        this.path = this.context.uniqueRoot().content();
    }

    @After
    public final void tearDown() throws Exception {
        Assert.assertFalse((boolean)this.context.resourceResolver().hasChanges());
    }

    @Test
    public void testBinaryFile() throws IOException {
        this.context.load().binaryFile("/sample-image.gif", this.path + "/sample-image.gif");
        Resource fileResource = this.context.resourceResolver().getResource(this.path + "/sample-image.gif");
        this.assertSampleImageFileSize(fileResource);
        this.assertMimeType(fileResource.getChild("jcr:content"), "image/gif");
    }

    @Test
    public void testBinaryFileWithMimeType() throws IOException {
        this.context.load().binaryFile("/sample-image.gif", this.path + "/sample-image.gif", "mime/test");
        Resource fileResource = this.context.resourceResolver().getResource(this.path + "/sample-image.gif");
        this.assertSampleImageFileSize(fileResource);
        this.assertMimeType(fileResource.getChild("jcr:content"), "mime/test");
    }

    @Test
    public void testBinaryResource() throws IOException {
        this.context.load().binaryResource("/sample-image.gif", this.path + "/sample-image.gif");
        Resource fileResource = this.context.resourceResolver().getResource(this.path + "/sample-image.gif");
        this.assertSampleImageFileSize(fileResource);
        this.assertMimeType(fileResource, "image/gif");
    }

    @Test
    public void testBinaryResourceWithMimeType() throws IOException {
        this.context.load().binaryResource("/sample-image.gif", this.path + "/sample-image.gif", "mime/test");
        Resource fileResource = this.context.resourceResolver().getResource(this.path + "/sample-image.gif");
        this.assertSampleImageFileSize(fileResource);
        this.assertMimeType(fileResource, "mime/test");
    }

    private void assertSampleImageFileSize(Resource resource) throws IOException {
        InputStream is = (InputStream)resource.adaptTo(InputStream.class);
        Assert.assertNotNull((String)("InputSteam is null for " + resource.getPath()), (Object)is);
        byte[] binaryData = IOUtils.toByteArray((InputStream)is);
        Assert.assertEquals((long)62L, (long)binaryData.length);
    }

    private void assertMimeType(Resource resource, String mimeType) {
        Assert.assertNotNull((Object)resource);
        Assert.assertEquals((Object)mimeType, (Object)ResourceUtil.getValueMap((Resource)resource).get("jcr:mimeType", String.class));
    }
}

