/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.sling.loader;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.io.InputStream;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.commons.mime.MimeTypeService;
import org.apache.sling.jcr.contentparser.ContentHandler;
import org.apache.sling.jcr.contentparser.ContentParser;
import org.apache.sling.jcr.contentparser.ContentParserFactory;
import org.apache.sling.jcr.contentparser.ContentType;
import org.apache.sling.jcr.contentparser.JsonParserFeature;
import org.apache.sling.jcr.contentparser.ParseException;
import org.apache.sling.jcr.contentparser.ParserOptions;
import org.apache.sling.testing.mock.sling.ResourceResolverType;
import org.apache.sling.testing.mock.sling.loader.LoaderContentHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public final class ContentLoader {
    private static final String CONTENTTYPE_OCTET_STREAM = "application/octet-stream";
    private static final Set<String> SHARED_IGNORED_NAMES = ImmutableSet.builder().add((Object)"jcr:baseVersion").add((Object)"jcr:predecessors").add((Object)"jcr:successors").add((Object)"jcr:versionHistory").add((Object)"jcr:checkedOut").add((Object)"jcr:isCheckedOut").add((Object)"rep:policy").build();
    private static final Set<String> MOCK_IGNORED_NAMES = ImmutableSet.builder().addAll(SHARED_IGNORED_NAMES).add((Object)"jcr:mixinTypes").build();
    private static final Set<String> OAK_IGNORED_NAMES = ImmutableSet.builder().addAll(SHARED_IGNORED_NAMES).add((Object)"jcr:uuid").add((Object)"jcr:created").build();
    private final ResourceResolver resourceResolver;
    private final BundleContext bundleContext;
    private final boolean autoCommit;
    private final Set<String> ignoredNames;
    private final ContentParser jsonParser;

    public ContentLoader(@NotNull ResourceResolver resourceResolver) {
        this(resourceResolver, null);
    }

    public ContentLoader(@NotNull ResourceResolver resourceResolver, @Nullable BundleContext bundleContext) {
        this(resourceResolver, bundleContext, true);
    }

    public ContentLoader(@NotNull ResourceResolver resourceResolver, @Nullable BundleContext bundleContext, boolean autoCommit) {
        this(resourceResolver, bundleContext, autoCommit, null);
    }

    public ContentLoader(@NotNull ResourceResolver resourceResolver, @Nullable BundleContext bundleContext, boolean autoCommit, @Nullable ResourceResolverType resourceResolverType) {
        this.resourceResolver = resourceResolver;
        this.bundleContext = bundleContext;
        this.autoCommit = autoCommit;
        this.ignoredNames = this.getIgnoredNamesForResourceResolverType(resourceResolverType);
        this.jsonParser = ContentParserFactory.create((ContentType)ContentType.JSON, (ParserOptions)new ParserOptions().detectCalendarValues(true).ignorePropertyNames(this.ignoredNames).ignoreResourceNames(this.ignoredNames).jsonParserFeatures(EnumSet.of(JsonParserFeature.COMMENTS, JsonParserFeature.QUOTE_TICK)));
    }

    private final Set<String> getIgnoredNamesForResourceResolverType(ResourceResolverType resourceResolverType) {
        if (resourceResolverType == null || resourceResolverType == ResourceResolverType.JCR_OAK) {
            return OAK_IGNORED_NAMES;
        }
        return MOCK_IGNORED_NAMES;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Resource json(@NotNull String classpathResource, @NotNull Resource parentResource, @NotNull String childName) {
        InputStream is = ContentLoader.class.getResourceAsStream(classpathResource);
        if (is == null) {
            throw new IllegalArgumentException("Classpath resource not found: " + classpathResource);
        }
        try {
            Resource resource = this.json(is, parentResource, childName);
            return resource;
        }
        finally {
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Resource json(@NotNull String classpathResource, @NotNull String destPath) {
        InputStream is = ContentLoader.class.getResourceAsStream(classpathResource);
        if (is == null) {
            throw new IllegalArgumentException("Classpath resource not found: " + classpathResource);
        }
        try {
            Resource resource = this.json(is, destPath);
            return resource;
        }
        finally {
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
    }

    @NotNull
    public Resource json(@NotNull InputStream inputStream, @NotNull Resource parentResource, @NotNull String childName) {
        return this.json(inputStream, parentResource.getPath() + "/" + childName);
    }

    @NotNull
    public Resource json(@NotNull InputStream inputStream, @NotNull String destPath) {
        try {
            String parentPath = ResourceUtil.getParent((String)destPath);
            String childName = ResourceUtil.getName((String)destPath);
            if (parentPath == null) {
                throw new IllegalArgumentException("Path has no parent: " + destPath);
            }
            Resource parentResource = this.resourceResolver.getResource(parentPath);
            if (parentResource == null) {
                parentResource = this.createResourceHierarchy(parentPath);
            }
            if (parentResource.getChild(childName) != null) {
                throw new IllegalArgumentException("Resource does already exist: " + destPath);
            }
            LoaderContentHandler contentHandler = new LoaderContentHandler(destPath, this.resourceResolver);
            this.jsonParser.parse((ContentHandler)contentHandler, inputStream);
            if (this.autoCommit) {
                this.resourceResolver.commit();
            }
            return this.resourceResolver.getResource(destPath);
        }
        catch (ParseException ex) {
            throw new RuntimeException(ex);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    @NotNull
    private Resource createResourceHierarchy(@NotNull String path) {
        String parentPath = ResourceUtil.getParent((String)path);
        if (parentPath == null) {
            throw new IllegalArgumentException("Path has no parent: " + path);
        }
        Resource parentResource = this.resourceResolver.getResource(parentPath);
        if (parentResource == null) {
            parentResource = this.createResourceHierarchy(parentPath);
        }
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("jcr:primaryType", "nt:unstructured");
        try {
            return this.resourceResolver.create(parentResource, ResourceUtil.getName((String)path), props);
        }
        catch (PersistenceException ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Resource binaryFile(@NotNull String classpathResource, @NotNull String path) {
        InputStream is = ContentLoader.class.getResourceAsStream(classpathResource);
        if (is == null) {
            throw new IllegalArgumentException("Classpath resource not found: " + classpathResource);
        }
        try {
            Resource resource = this.binaryFile(is, path, this.detectMimeTypeFromNames(classpathResource, path));
            return resource;
        }
        finally {
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Resource binaryFile(@NotNull String classpathResource, @NotNull String path, @NotNull String mimeType) {
        InputStream is = ContentLoader.class.getResourceAsStream(classpathResource);
        if (is == null) {
            throw new IllegalArgumentException("Classpath resource not found: " + classpathResource);
        }
        try {
            Resource resource = this.binaryFile(is, path, mimeType);
            return resource;
        }
        finally {
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
    }

    @NotNull
    public Resource binaryFile(@NotNull InputStream inputStream, @NotNull String path) {
        return this.binaryFile(inputStream, path, this.detectMimeTypeFromNames(path));
    }

    @NotNull
    public Resource binaryFile(@NotNull InputStream inputStream, @NotNull String path, @NotNull String mimeType) {
        String parentPath = ResourceUtil.getParent((String)path, (int)1);
        String name = ResourceUtil.getName((String)path);
        if (parentPath == null) {
            throw new IllegalArgumentException("Path has no parent: " + path);
        }
        Resource parentResource = this.resourceResolver.getResource(parentPath);
        if (parentResource == null) {
            parentResource = this.createResourceHierarchy(parentPath);
        }
        return this.binaryFile(inputStream, parentResource, name, mimeType);
    }

    @NotNull
    public Resource binaryFile(@NotNull InputStream inputStream, @NotNull Resource parentResource, @NotNull String name) {
        return this.binaryFile(inputStream, parentResource, name, this.detectMimeTypeFromNames(name));
    }

    @NotNull
    public Resource binaryFile(@NotNull InputStream inputStream, @NotNull Resource parentResource, @NotNull String name, @NotNull String mimeType) {
        try {
            Resource file = this.resourceResolver.create(parentResource, name, (Map)ImmutableMap.builder().put((Object)"jcr:primaryType", (Object)"nt:file").build());
            this.resourceResolver.create(file, "jcr:content", (Map)ImmutableMap.builder().put((Object)"jcr:primaryType", (Object)"nt:resource").put((Object)"jcr:data", (Object)inputStream).put((Object)"jcr:mimeType", (Object)mimeType).build());
            if (this.autoCommit) {
                this.resourceResolver.commit();
            }
            return file;
        }
        catch (PersistenceException ex) {
            throw new RuntimeException("Unable to create resource at " + parentResource.getPath() + "/" + name, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Resource binaryResource(@NotNull String classpathResource, @NotNull String path) {
        InputStream is = ContentLoader.class.getResourceAsStream(classpathResource);
        if (is == null) {
            throw new IllegalArgumentException("Classpath resource not found: " + classpathResource);
        }
        try {
            Resource resource = this.binaryResource(is, path, this.detectMimeTypeFromNames(classpathResource, path));
            return resource;
        }
        finally {
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Resource binaryResource(@NotNull String classpathResource, @NotNull String path, @NotNull String mimeType) {
        InputStream is = ContentLoader.class.getResourceAsStream(classpathResource);
        if (is == null) {
            throw new IllegalArgumentException("Classpath resource not found: " + classpathResource);
        }
        try {
            Resource resource = this.binaryResource(is, path, mimeType);
            return resource;
        }
        finally {
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
    }

    @NotNull
    public Resource binaryResource(@NotNull InputStream inputStream, @NotNull String path) {
        return this.binaryResource(inputStream, path, this.detectMimeTypeFromNames(path));
    }

    @NotNull
    public Resource binaryResource(@NotNull InputStream inputStream, @NotNull String path, @NotNull String mimeType) {
        String parentPath = ResourceUtil.getParent((String)path, (int)1);
        String name = ResourceUtil.getName((String)path);
        if (parentPath == null) {
            throw new IllegalArgumentException("Path has no parent: " + path);
        }
        Resource parentResource = this.resourceResolver.getResource(parentPath);
        if (parentResource == null) {
            parentResource = this.createResourceHierarchy(parentPath);
        }
        return this.binaryResource(inputStream, parentResource, name, mimeType);
    }

    @NotNull
    public Resource binaryResource(@NotNull InputStream inputStream, @NotNull Resource parentResource, @NotNull String name) {
        return this.binaryResource(inputStream, parentResource, name, this.detectMimeTypeFromNames(name));
    }

    @NotNull
    public Resource binaryResource(@NotNull InputStream inputStream, @NotNull Resource parentResource, @NotNull String name, @NotNull String mimeType) {
        try {
            Resource resource = this.resourceResolver.create(parentResource, name, (Map)ImmutableMap.builder().put((Object)"jcr:primaryType", (Object)"nt:resource").put((Object)"jcr:data", (Object)inputStream).put((Object)"jcr:mimeType", (Object)mimeType).build());
            if (this.autoCommit) {
                this.resourceResolver.commit();
            }
            return resource;
        }
        catch (PersistenceException ex) {
            throw new RuntimeException("Unable to create resource at " + parentResource.getPath() + "/" + name, ex);
        }
    }

    @NotNull
    private String detectMimeTypeFromNames(String ... names) {
        String mimeType = null;
        for (String name : names) {
            ServiceReference ref;
            String fileExtension = StringUtils.substringAfterLast((String)name, (String)".");
            if (this.bundleContext == null || !StringUtils.isNotEmpty((CharSequence)fileExtension) || (ref = this.bundleContext.getServiceReference(MimeTypeService.class)) == null) continue;
            MimeTypeService mimeTypeService = (MimeTypeService)this.bundleContext.getService(ref);
            mimeType = mimeTypeService.getMimeType(fileExtension);
            break;
        }
        return StringUtils.defaultString(mimeType, (String)CONTENTTYPE_OCTET_STREAM);
    }
}

