/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.sling.builder;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.testing.mock.osgi.MapUtil;
import org.jetbrains.annotations.NotNull;

public class ContentBuilder {
    static final String DUMMY_TEMPLATE = "/apps/sample/templates/template1";
    protected final ResourceResolver resourceResolver;

    public ContentBuilder(@NotNull ResourceResolver resourceResolver) {
        this.resourceResolver = resourceResolver;
    }

    @NotNull
    public final Resource resource(@NotNull String path) {
        return this.resource(path, (Map<String, Object>)ValueMap.EMPTY);
    }

    @NotNull
    public final Resource resource(@NotNull String path, @NotNull Map<String, Object> properties) {
        String parentPath = ResourceUtil.getParent((String)path);
        if (parentPath == null) {
            throw new IllegalArgumentException("Path has no parent: " + path);
        }
        Resource parentResource = this.ensureResourceExists(parentPath);
        String name = ResourceUtil.getName((String)path);
        try {
            return this.resourceResolver.create(parentResource, name, properties);
        }
        catch (PersistenceException ex) {
            throw new RuntimeException("Unable to create resource at " + path, ex);
        }
    }

    @NotNull
    public final Resource resource(@NotNull String path, Object ... properties) {
        return this.resource(path, MapUtil.toMap((Object[])properties));
    }

    @NotNull
    protected final Resource ensureResourceExists(@NotNull String path) {
        if (StringUtils.isEmpty((CharSequence)path) || StringUtils.equals((CharSequence)path, (CharSequence)"/")) {
            return this.resourceResolver.getResource("/");
        }
        Resource resource = this.resourceResolver.getResource(path);
        if (resource != null) {
            return resource;
        }
        String parentPath = ResourceUtil.getParent((String)path);
        if (parentPath == null) {
            throw new IllegalArgumentException("Path has no parent: " + path);
        }
        String name = ResourceUtil.getName((String)path);
        Resource parentResource = this.ensureResourceExists(parentPath);
        try {
            resource = this.resourceResolver.create(parentResource, name, (Map)ImmutableMap.builder().put((Object)"jcr:primaryType", (Object)"nt:unstructured").build());
            this.resourceResolver.commit();
            return resource;
        }
        catch (PersistenceException ex) {
            throw new RuntimeException("Unable to create resource at " + path, ex);
        }
    }
}

