/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.sling;

import java.lang.reflect.Array;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RequestDispatcherOptions;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.scripting.InvalidServiceFilterSyntaxException;
import org.apache.sling.api.scripting.SlingScript;
import org.apache.sling.api.scripting.SlingScriptHelper;
import org.jetbrains.annotations.NotNull;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public final class MockSlingScriptHelper
implements SlingScriptHelper {
    @NotNull
    private final SlingHttpServletRequest request;
    @NotNull
    private final SlingHttpServletResponse response;
    @NotNull
    private final BundleContext bundleContext;
    private SlingScript script;

    public MockSlingScriptHelper(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response, @NotNull BundleContext bundleContext) {
        this.request = request;
        this.response = response;
        this.bundleContext = bundleContext;
    }

    @NotNull
    public SlingHttpServletRequest getRequest() {
        return this.request;
    }

    @NotNull
    public SlingHttpServletResponse getResponse() {
        return this.response;
    }

    public <ServiceType> ServiceType getService(@NotNull Class<ServiceType> serviceType) {
        ServiceReference serviceReference = this.bundleContext.getServiceReference(serviceType.getName());
        if (serviceReference != null) {
            return (ServiceType)this.bundleContext.getService(serviceReference);
        }
        return null;
    }

    public <ServiceType> ServiceType[] getServices(@NotNull Class<ServiceType> serviceType, String filter) {
        try {
            ServiceReference[] serviceReferences = this.bundleContext.getServiceReferences(serviceType.getName(), filter);
            if (serviceReferences != null) {
                Object[] services = (Object[])Array.newInstance(serviceType, serviceReferences.length);
                for (int i = 0; i < serviceReferences.length; ++i) {
                    services[i] = this.bundleContext.getService(serviceReferences[i]);
                }
                return services;
            }
            return ArrayUtils.EMPTY_OBJECT_ARRAY;
        }
        catch (InvalidSyntaxException ex) {
            throw new InvalidServiceFilterSyntaxException(filter, ex.getMessage(), (Throwable)ex);
        }
    }

    @NotNull
    public SlingScript getScript() {
        return this.script;
    }

    public void setScript(@NotNull SlingScript script) {
        this.script = script;
    }

    public void dispose() {
        throw new UnsupportedOperationException();
    }

    public void forward(@NotNull String path, RequestDispatcherOptions requestDispatcherOptions) {
        throw new UnsupportedOperationException();
    }

    public void forward(@NotNull String path, String requestDispatcherOptions) {
        throw new UnsupportedOperationException();
    }

    public void forward(@NotNull String path) {
        throw new UnsupportedOperationException();
    }

    public void forward(@NotNull Resource resource) {
        throw new UnsupportedOperationException();
    }

    public void forward(@NotNull Resource resource, String requestDispatcherOptions) {
        throw new UnsupportedOperationException();
    }

    public void forward(@NotNull Resource resource, RequestDispatcherOptions requestDispatcherOptions) {
        throw new UnsupportedOperationException();
    }

    public void include(@NotNull String path, RequestDispatcherOptions requestDispatcherOptions) {
        throw new UnsupportedOperationException();
    }

    public void include(@NotNull String path, String requestDispatcherOptions) {
        throw new UnsupportedOperationException();
    }

    public void include(@NotNull String path) {
        throw new UnsupportedOperationException();
    }

    public void include(@NotNull Resource resource) {
        throw new UnsupportedOperationException();
    }

    public void include(@NotNull Resource resource, String requestDispatcherOptions) {
        throw new UnsupportedOperationException();
    }

    public void include(@NotNull Resource resource, RequestDispatcherOptions requestDispatcherOptions) {
        throw new UnsupportedOperationException();
    }
}

