/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.authorization.permission;

import com.google.common.base.Predicate;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.security.authorization.permission.PermissionEntry;

final class EntryPredicate
implements Predicate<PermissionEntry> {
    private final Tree tree;
    private final PropertyState property;
    private final String path;
    private final String parentPath;
    private final Tree parent;
    private final boolean respectParent;

    EntryPredicate() {
        this(null, null, null, false);
    }

    EntryPredicate(@Nonnull Tree tree, @Nullable PropertyState property, boolean respectParent) {
        this(tree, property, tree.getPath(), respectParent);
    }

    EntryPredicate(@Nonnull String path, boolean respectParent) {
        this(null, null, path, respectParent);
    }

    private EntryPredicate(@Nullable Tree tree, @Nullable PropertyState property, @Nullable String path, boolean respectParent) {
        this.tree = tree;
        this.property = property;
        this.path = path;
        if (respectParent) {
            this.parentPath = path == null || "/".equals(path) ? null : PathUtils.getParentPath(path);
            this.parent = tree == null || tree.isRoot() ? null : tree.getParent();
        } else {
            this.parentPath = null;
            this.parent = null;
        }
        this.respectParent = this.parent != null || this.parentPath != null;
    }

    @CheckForNull
    String getPath() {
        return this.path;
    }

    public boolean apply(@Nullable PermissionEntry entry) {
        return this.apply(entry, true);
    }

    public boolean apply(@Nullable PermissionEntry entry, boolean respectParent) {
        if (entry == null) {
            return false;
        }
        respectParent &= this.respectParent;
        if (this.tree != null) {
            return entry.matches(this.tree, this.property) || respectParent && this.parent != null && entry.matches(this.parent, null);
        }
        if (this.path != null) {
            return entry.matches(this.path) || respectParent && this.parentPath != null && entry.matches(this.parentPath);
        }
        return entry.matches();
    }
}

