/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.version;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.nodetype.PropertyDefinition;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.UUIDUtils;
import org.apache.jackrabbit.oak.plugins.memory.EmptyNodeState;
import org.apache.jackrabbit.oak.plugins.memory.MemoryNodeBuilder;
import org.apache.jackrabbit.oak.plugins.memory.PropertyStates;
import org.apache.jackrabbit.oak.plugins.nodetype.ReadOnlyNodeTypeManager;
import org.apache.jackrabbit.oak.plugins.tree.factories.TreeFactory;
import org.apache.jackrabbit.oak.plugins.tree.impl.ImmutableTree;
import org.apache.jackrabbit.oak.plugins.version.DateVersionSelector;
import org.apache.jackrabbit.oak.plugins.version.ReadWriteVersionManager;
import org.apache.jackrabbit.oak.plugins.version.Utils;
import org.apache.jackrabbit.oak.plugins.version.VersionExceptionCode;
import org.apache.jackrabbit.oak.plugins.version.VersionSelector;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class VersionableState {
    private static final Logger log = LoggerFactory.getLogger(VersionableState.class);
    private static final String JCR_CHILDVERSIONHISTORY = "jcr:childVersionHistory";
    private static final Set<String> BASIC_PROPERTIES = new HashSet<String>();
    private static final Set<String> BASIC_FROZEN_PROPERTIES = new HashSet<String>();
    private final NodeBuilder version;
    private final NodeBuilder history;
    private final NodeBuilder frozenNode;
    private final NodeBuilder versionable;
    private final ReadWriteVersionManager vMgr;
    private final ReadOnlyNodeTypeManager ntMgr;

    private VersionableState(@Nonnull NodeBuilder version, @Nonnull NodeBuilder history, @Nonnull NodeBuilder versionable, @Nonnull ReadWriteVersionManager vMgr, @Nonnull ReadOnlyNodeTypeManager ntMgr) {
        this.version = (NodeBuilder)Preconditions.checkNotNull((Object)version);
        this.history = (NodeBuilder)Preconditions.checkNotNull((Object)history);
        this.frozenNode = version.child("jcr:frozenNode");
        this.versionable = (NodeBuilder)Preconditions.checkNotNull((Object)versionable);
        this.vMgr = (ReadWriteVersionManager)Preconditions.checkNotNull((Object)vMgr);
        this.ntMgr = (ReadOnlyNodeTypeManager)Preconditions.checkNotNull((Object)ntMgr);
    }

    @Nonnull
    static VersionableState fromVersion(@Nonnull NodeBuilder version, @Nonnull NodeBuilder history, @Nonnull NodeBuilder versionable, @Nonnull ReadWriteVersionManager vMgr, @Nonnull ReadOnlyNodeTypeManager ntMgr) {
        VersionableState state = new VersionableState(version, history, versionable, vMgr, ntMgr);
        return state.initFrozen(version.child("jcr:frozenNode"), versionable, Utils.uuidFromNode(versionable));
    }

    static VersionableState forRestore(@Nonnull NodeBuilder version, @Nonnull NodeBuilder history, @Nonnull NodeBuilder versionable, @Nonnull ReadWriteVersionManager vMgr, @Nonnull ReadOnlyNodeTypeManager ntMgr) {
        return new VersionableState(version, history, versionable, vMgr, ntMgr);
    }

    private VersionableState initFrozen(NodeBuilder frozen, NodeBuilder node, String nodeId) {
        frozen.setProperty("jcr:uuid", UUIDUtils.generateUUID(), Type.STRING);
        frozen.setProperty("jcr:primaryType", "nt:frozenNode", Type.NAME);
        ArrayList mixinTypes = node.hasProperty("jcr:mixinTypes") ? Lists.newArrayList(node.getNames("jcr:mixinTypes")) : Collections.emptyList();
        frozen.setProperty("jcr:frozenUuid", nodeId, Type.STRING);
        frozen.setProperty("jcr:frozenPrimaryType", Utils.primaryTypeOf(node), Type.NAME);
        if (mixinTypes.isEmpty()) {
            frozen.removeProperty("jcr:frozenMixinTypes");
        } else {
            frozen.setProperty("jcr:frozenMixinTypes", mixinTypes, Type.NAMES);
        }
        return this;
    }

    NodeBuilder create() throws CommitFailedException {
        try {
            this.createFrozen(this.versionable, Utils.uuidFromNode(this.versionable), this.frozenNode, 2);
            return this.frozenNode;
        }
        catch (RepositoryException e) {
            throw new CommitFailedException("Version", VersionExceptionCode.UNEXPECTED_REPOSITORY_EXCEPTION.ordinal(), "Unexpected RepositoryException", e);
        }
    }

    public NodeBuilder restore(@Nullable VersionSelector selector) throws CommitFailedException {
        try {
            if (selector == null) {
                String created = this.version.getProperty("jcr:created").getValue(Type.DATE);
                selector = new DateVersionSelector(created);
            }
            this.restoreFrozen(this.frozenNode, this.versionable, selector);
            this.restoreVersionable(this.versionable, this.version);
            return this.versionable;
        }
        catch (RepositoryException e) {
            throw new CommitFailedException("Version", VersionExceptionCode.UNEXPECTED_REPOSITORY_EXCEPTION.ordinal(), "Unexpected RepositoryException", e);
        }
    }

    private void restoreState(@Nonnull NodeBuilder src, @Nonnull NodeBuilder destParent, @Nonnull String name, @Nonnull VersionSelector selector) throws RepositoryException, CommitFailedException {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull((Object)destParent);
        String primaryType = Utils.primaryTypeOf(src);
        if (primaryType.equals("nt:frozenNode")) {
            destParent.getChildNode(name).remove();
            this.restoreFrozen(src, destParent.child(name), selector);
        } else if (primaryType.equals("nt:versionedChild")) {
            if (!destParent.hasChildNode(name)) {
                this.restoreVersionedChild(src, destParent.child(name), selector);
            }
        } else {
            destParent.getChildNode(name).remove();
            this.restoreCopiedNode(src, destParent.child(name), selector);
        }
    }

    private void restoreFrozen(@Nonnull NodeBuilder frozen, @Nonnull NodeBuilder dest, @Nonnull VersionSelector selector) throws RepositoryException, CommitFailedException {
        this.restoreFrozenTypeAndUUID(frozen, dest);
        for (PropertyState propertyState : frozen.getProperties()) {
            int action;
            if (BASIC_FROZEN_PROPERTIES.contains(propertyState.getName()) || (action = this.getOPV(dest, propertyState)) != 1 && action != 2) continue;
            dest.setProperty(propertyState);
        }
        for (PropertyState propertyState : dest.getProperties()) {
            String propName = propertyState.getName();
            if (BASIC_PROPERTIES.contains(propName) || frozen.hasProperty(propName)) continue;
            int action = this.getOPV(dest, propertyState);
            if (action == 1 || action == 2 || action == 6) {
                dest.removeProperty(propName);
                continue;
            }
            if (action == 5) continue;
            if (action == 3) {
                this.resetToDefaultValue(dest, propertyState);
                continue;
            }
            if (action != 4 || "jcr:primaryType".equals(propName) || "jcr:mixinTypes".equals(propName)) continue;
            log.warn("OPV.COMPUTE not implemented for restoring property: " + propName);
        }
        this.restoreChildren(frozen, dest, selector);
    }

    private void restoreFrozenTypeAndUUID(@Nonnull NodeBuilder frozen, @Nonnull NodeBuilder dest) {
        dest.setProperty("jcr:primaryType", frozen.getName("jcr:frozenPrimaryType"), Type.NAME);
        String id = frozen.getProperty("jcr:frozenUuid").getValue(Type.STRING);
        if (id.indexOf(47) == -1) {
            dest.setProperty("jcr:uuid", id, Type.STRING);
        }
        if (frozen.hasProperty("jcr:frozenMixinTypes")) {
            dest.setProperty("jcr:mixinTypes", frozen.getNames("jcr:frozenMixinTypes"), Type.NAMES);
        }
    }

    private void restoreCopiedNode(NodeBuilder src, NodeBuilder dest, VersionSelector selector) throws RepositoryException, CommitFailedException {
        if (Utils.primaryTypeOf(src).equals("nt:frozenNode")) {
            this.restoreFrozenTypeAndUUID(src, dest);
            this.copyProperties(src, dest, new OPVProvider(){

                @Override
                public int getAction(NodeBuilder src, NodeBuilder dest, PropertyState prop) throws RepositoryException {
                    if (BASIC_FROZEN_PROPERTIES.contains(prop.getName())) {
                        return 5;
                    }
                    return 1;
                }
            }, true);
        } else {
            this.copyProperties(src, dest, OPVForceCopy.INSTANCE, false);
        }
        this.restoreChildren(src, dest, selector);
    }

    private void restoreVersionedChild(NodeBuilder versionedChild, NodeBuilder dest, VersionSelector selector) throws RepositoryException, CommitFailedException {
        PropertyState id = versionedChild.getProperty(JCR_CHILDVERSIONHISTORY);
        if (id == null) {
            throw new RepositoryException("Mandatory property jcr:childVersionHistory is missing.");
        }
        this.vMgr.restore(id.getValue(Type.REFERENCE), selector, dest);
    }

    private void restoreChildren(NodeBuilder src, NodeBuilder dest, VersionSelector selector) throws RepositoryException, CommitFailedException {
        int action;
        for (String name : src.getChildNodeNames()) {
            NodeBuilder srcChild = src.getChildNode(name);
            action = this.getOPV(dest, srcChild, name);
            if (action == 1) {
                dest.getChildNode(name).remove();
                this.restoreCopiedNode(srcChild, dest.child(name), selector);
                continue;
            }
            if (action != 2) continue;
            this.restoreState(srcChild, dest, name, selector);
        }
        for (String name : dest.getChildNodeNames()) {
            if (src.hasChildNode(name)) continue;
            NodeBuilder destChild = dest.getChildNode(name);
            action = this.getOPV(dest, destChild, name);
            if (action == 1 || action == 2 || action == 6) {
                dest.getChildNode(name).remove();
                continue;
            }
            if (action == 5) continue;
            if (action == 3) {
                log.warn("OPV.INITIALIZE not implemented for restoring child nodes.");
                continue;
            }
            if (action != 4) continue;
            log.warn("OPV.COMPUTE not implemented for restoring child nodes: ");
        }
    }

    private void restoreVersionable(@Nonnull NodeBuilder versionable, @Nonnull NodeBuilder version) {
        ((NodeBuilder)Preconditions.checkNotNull((Object)versionable)).setProperty("jcr:isCheckedOut", false, Type.BOOLEAN);
        versionable.setProperty("jcr:versionHistory", Utils.uuidFromNode(this.history), Type.REFERENCE);
        versionable.setProperty("jcr:baseVersion", Utils.uuidFromNode(version), Type.REFERENCE);
        versionable.setProperty("jcr:predecessors", Collections.emptyList(), Type.REFERENCES);
    }

    private void resetToDefaultValue(NodeBuilder dest, PropertyState p) throws RepositoryException {
        Tree tree = TreeFactory.createReadOnlyTree(dest.getNodeState());
        PropertyDefinition def = this.ntMgr.getDefinition(tree, p, true);
        Value[] values = def.getDefaultValues();
        if (values != null) {
            if (p.isArray()) {
                p = PropertyStates.createProperty(p.getName(), values);
                dest.setProperty(p);
            } else if (values.length > 0) {
                p = PropertyStates.createProperty(p.getName(), values[0]);
                dest.setProperty(p);
            }
        }
    }

    private void createFrozen(NodeBuilder src, String srcId, NodeBuilder dest, int opva) throws CommitFailedException, RepositoryException {
        this.initFrozen(dest, src, srcId);
        OPVProvider opvProvider = opva == 1 ? OPVForceCopy.INSTANCE : new OPVVersion();
        this.copyProperties(src, dest, opvProvider, true);
        for (String name : src.getChildNodeNames()) {
            if (NodeStateUtils.isHidden(name)) continue;
            NodeBuilder child = src.getChildNode(name);
            String childId = this.getChildId(srcId, child, name);
            int opv = this.getOPV(src, child, name);
            if (opv == 6) {
                throw new CommitFailedException("Version", VersionExceptionCode.OPV_ABORT_ITEM_PRESENT.ordinal(), "Checkin aborted due to OPV abort in " + name);
            }
            if (opv == 2) {
                if (this.ntMgr.isNodeType(TreeFactory.createReadOnlyTree(child.getNodeState()), "mix:versionable")) {
                    this.versionedChild(child, dest.child(name));
                    continue;
                }
                this.createFrozen(child, childId, dest.child(name), 1);
                continue;
            }
            if (opv != 1) continue;
            this.createFrozen(child, childId, dest.child(name), 1);
        }
    }

    private void versionedChild(NodeBuilder src, NodeBuilder dest) {
        String ref = src.getProperty("jcr:versionHistory").getValue(Type.REFERENCE);
        dest.setProperty("jcr:primaryType", "nt:versionedChild", Type.NAME);
        dest.setProperty(JCR_CHILDVERSIONHISTORY, ref, Type.REFERENCE);
    }

    private String getChildId(String parentId, NodeBuilder child, String name) {
        if (child.hasProperty("jcr:uuid")) {
            return Utils.uuidFromNode(child);
        }
        return parentId + "/" + name;
    }

    private void copyProperties(NodeBuilder src, NodeBuilder dest, OPVProvider opvProvider, boolean ignoreTypeAndUUID) throws RepositoryException, CommitFailedException {
        for (PropertyState propertyState : src.getProperties()) {
            int opv = opvProvider.getAction(src, dest, propertyState);
            String propName = propertyState.getName();
            if (opv == 6) {
                throw new CommitFailedException("Version", VersionExceptionCode.OPV_ABORT_ITEM_PRESENT.ordinal(), "Checkin aborted due to OPV abort in " + propName);
            }
            if (ignoreTypeAndUUID && BASIC_PROPERTIES.contains(propName) || VersionableState.isHiddenProperty(propName) || opv != 2 && opv != 1) continue;
            dest.setProperty(propertyState);
        }
    }

    private static boolean isHiddenProperty(@Nonnull String propName) {
        return NodeStateUtils.isHidden(propName) && !":childOrder".equals(propName);
    }

    private int getOPV(NodeBuilder parent, NodeBuilder child, String childName) throws RepositoryException {
        NodeState childState;
        if (childName.startsWith(":")) {
            return 5;
        }
        ImmutableTree parentTree = new ImmutableTree(parent.getNodeState());
        if ("nt:frozenNode".equals(child.getName("jcr:primaryType"))) {
            MemoryNodeBuilder builder = new MemoryNodeBuilder(EmptyNodeState.EMPTY_NODE);
            builder.setProperty("jcr:primaryType", child.getName("jcr:frozenPrimaryType"), Type.NAME);
            builder.setProperty("jcr:mixinTypes", child.getNames("jcr:mixinTypes"), Type.NAMES);
            childState = builder.getNodeState();
        } else {
            childState = child.getNodeState();
        }
        ImmutableTree childTree = new ImmutableTree(parentTree, childName, childState);
        return this.ntMgr.getDefinition((Tree)parentTree, childTree).getOnParentVersion();
    }

    private int getOPV(NodeBuilder node, PropertyState property) throws RepositoryException {
        if (property.getName().charAt(0) == ':') {
            return 1;
        }
        return this.ntMgr.getDefinition(TreeFactory.createReadOnlyTree(node.getNodeState()), property, false).getOnParentVersion();
    }

    static {
        BASIC_PROPERTIES.add("jcr:primaryType");
        BASIC_PROPERTIES.add("jcr:uuid");
        BASIC_PROPERTIES.add("jcr:mixinTypes");
        BASIC_FROZEN_PROPERTIES.addAll(BASIC_PROPERTIES);
        BASIC_FROZEN_PROPERTIES.add("jcr:frozenPrimaryType");
        BASIC_FROZEN_PROPERTIES.add("jcr:frozenUuid");
        BASIC_FROZEN_PROPERTIES.add("jcr:frozenMixinTypes");
    }

    private final class OPVVersion
    implements OPVProvider {
        private OPVVersion() {
        }

        @Override
        public int getAction(NodeBuilder src, NodeBuilder dest, PropertyState prop) throws RepositoryException {
            String propName = prop.getName();
            if (BASIC_FROZEN_PROPERTIES.contains(propName)) {
                return 5;
            }
            if (VersionableState.isHiddenProperty(propName)) {
                return 5;
            }
            return VersionableState.this.getOPV(src, prop);
        }
    }

    private static final class OPVForceCopy
    implements OPVProvider {
        private static final OPVProvider INSTANCE = new OPVForceCopy();

        private OPVForceCopy() {
        }

        @Override
        public int getAction(NodeBuilder src, NodeBuilder dest, PropertyState prop) {
            return 1;
        }
    }

    private static interface OPVProvider {
        public int getAction(NodeBuilder var1, NodeBuilder var2, PropertyState var3) throws RepositoryException;
    }
}

