/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.observation.filter;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.spi.state.NodeState;

public class UuidPredicate
implements Predicate<NodeState> {
    private final String[] uuids;

    public UuidPredicate(@Nonnull String[] uuids) {
        this.uuids = (String[])Preconditions.checkNotNull((Object)uuids);
    }

    public boolean apply(NodeState node) {
        if (this.uuids.length == 0) {
            return false;
        }
        PropertyState uuidProperty = node.getProperty("jcr:uuid");
        if (uuidProperty == null) {
            return false;
        }
        String parentUuid = uuidProperty.getValue(Type.STRING);
        for (String uuid : this.uuids) {
            if (!parentUuid.equals(uuid)) continue;
            return true;
        }
        return false;
    }
}

