/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.migration;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collections;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.memory.EmptyNodeState;
import org.apache.jackrabbit.oak.plugins.memory.MemoryChildNodeEntry;
import org.apache.jackrabbit.oak.plugins.memory.PropertyStates;
import org.apache.jackrabbit.oak.spi.state.AbstractNodeState;
import org.apache.jackrabbit.oak.spi.state.ChildNodeEntry;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateDiff;
import org.apache.jackrabbit.oak.spi.state.ReadOnlyBuilder;

public abstract class AbstractDecoratedNodeState
extends AbstractNodeState {
    protected final NodeState delegate;

    protected AbstractDecoratedNodeState(@Nonnull NodeState delegate) {
        this.delegate = delegate;
    }

    public NodeState getDelegate() {
        return this.delegate;
    }

    protected boolean hideChild(@Nonnull String name, @Nonnull NodeState delegateChild) {
        return false;
    }

    @Nonnull
    protected abstract NodeState decorateChild(@Nonnull String var1, @Nonnull NodeState var2);

    @Nonnull
    private NodeState decorate(@Nonnull String name, @Nonnull NodeState child) {
        return this.hideChild(name, child) ? EmptyNodeState.MISSING_NODE : this.decorateChild(name, child);
    }

    protected boolean hideProperty(@Nonnull String name) {
        return false;
    }

    @Nonnull
    protected Iterable<PropertyState> getNewPropertyStates() {
        return Collections.emptyList();
    }

    @CheckForNull
    protected abstract PropertyState decorateProperty(@Nonnull PropertyState var1);

    @CheckForNull
    private PropertyState decorate(@Nullable PropertyState property) {
        return property == null || this.hideProperty(property.getName()) ? null : this.decorateProperty(property);
    }

    protected static PropertyState fixChildOrderPropertyState(NodeState nodeState, PropertyState propertyState) {
        if (propertyState != null && ":childOrder".equals(propertyState.getName())) {
            ArrayList childNodeNames = new ArrayList();
            Iterables.addAll(childNodeNames, nodeState.getChildNodeNames());
            Iterable values = Iterables.filter(propertyState.getValue(Type.NAMES), (Predicate)Predicates.in(childNodeNames));
            return PropertyStates.createProperty(":childOrder", (Object)values, Type.NAMES);
        }
        return propertyState;
    }

    @Override
    @Nonnull
    public NodeBuilder builder() {
        return new ReadOnlyBuilder(this);
    }

    @Override
    public boolean exists() {
        return this.delegate.exists();
    }

    @Override
    public boolean hasChildNode(@Nonnull String name) {
        return this.getChildNode(name).exists();
    }

    @Override
    @Nonnull
    public NodeState getChildNode(@Nonnull String name) throws IllegalArgumentException {
        return this.decorate(name, this.delegate.getChildNode(name));
    }

    @Override
    @Nonnull
    public Iterable<? extends ChildNodeEntry> getChildNodeEntries() {
        Iterable transformed = Iterables.transform(this.delegate.getChildNodeEntries(), (Function)new Function<ChildNodeEntry, ChildNodeEntry>(){

            @Nullable
            public ChildNodeEntry apply(@Nullable ChildNodeEntry childNodeEntry) {
                String name;
                NodeState nodeState;
                if (childNodeEntry != null && (nodeState = AbstractDecoratedNodeState.this.decorate(name = childNodeEntry.getName(), childNodeEntry.getNodeState())).exists()) {
                    return new MemoryChildNodeEntry(name, nodeState);
                }
                return null;
            }
        });
        return Iterables.filter((Iterable)transformed, (Predicate)Predicates.notNull());
    }

    @Override
    @CheckForNull
    public PropertyState getProperty(@Nonnull String name) {
        PropertyState ps = this.decorate(this.delegate.getProperty(name));
        if (ps == null) {
            for (PropertyState p : this.getNewPropertyStates()) {
                if (!name.equals(p.getName())) continue;
                ps = p;
                break;
            }
        }
        return ps;
    }

    @Override
    @Nonnull
    public Iterable<? extends PropertyState> getProperties() {
        Iterable propertyStates = Iterables.transform(this.delegate.getProperties(), (Function)new Function<PropertyState, PropertyState>(){

            @CheckForNull
            public PropertyState apply(@Nullable PropertyState propertyState) {
                return AbstractDecoratedNodeState.this.decorate(propertyState);
            }
        });
        return Iterables.filter((Iterable)Iterables.concat((Iterable)propertyStates, this.getNewPropertyStates()), (Predicate)Predicates.notNull());
    }

    @Override
    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this.getClass() == other.getClass()) {
            AbstractDecoratedNodeState o = (AbstractDecoratedNodeState)other;
            return this.delegate.equals(o.delegate);
        }
        return this.delegate.equals(other);
    }

    @Override
    public boolean compareAgainstBaseState(NodeState base, NodeStateDiff diff) {
        return AbstractNodeState.compareAgainstBaseState(this, base, new DecoratingDiff(diff, this));
    }

    private static class DecoratingDiff
    implements NodeStateDiff {
        private final NodeStateDiff diff;
        private AbstractDecoratedNodeState nodeState;

        private DecoratingDiff(NodeStateDiff diff, AbstractDecoratedNodeState nodeState) {
            this.diff = diff;
            this.nodeState = nodeState;
        }

        @Override
        public boolean childNodeAdded(String name, NodeState after) {
            return this.diff.childNodeAdded(name, this.nodeState.decorate(name, after));
        }

        @Override
        public boolean childNodeChanged(String name, NodeState before, NodeState after) {
            return this.diff.childNodeChanged(name, before, this.nodeState.decorate(name, after));
        }

        @Override
        public boolean childNodeDeleted(String name, NodeState before) {
            return this.diff.childNodeDeleted(name, before);
        }

        @Override
        public boolean propertyAdded(PropertyState after) {
            return this.diff.propertyAdded(this.nodeState.decorate(after));
        }

        @Override
        public boolean propertyChanged(PropertyState before, PropertyState after) {
            return this.diff.propertyChanged(this.nodeState.decorate(before), this.nodeState.decorate(after));
        }

        @Override
        public boolean propertyDeleted(PropertyState before) {
            return this.diff.propertyDeleted(this.nodeState.decorate(before));
        }
    }
}

