/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.property.jmx;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.common.collect.TreeTraverser;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import javax.annotation.Nonnull;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.commons.jmx.AnnotatedStandardMBean;
import org.apache.jackrabbit.oak.osgi.OsgiWhiteboard;
import org.apache.jackrabbit.oak.plugins.index.property.jmx.PropertyIndexStatsMBean;
import org.apache.jackrabbit.oak.plugins.tree.factories.TreeFactory;
import org.apache.jackrabbit.oak.spi.state.ChildNodeEntry;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateUtils;
import org.apache.jackrabbit.oak.spi.state.NodeStore;
import org.apache.jackrabbit.oak.spi.whiteboard.Registration;
import org.apache.jackrabbit.oak.spi.whiteboard.WhiteboardUtils;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={})
public class PropertyIndexStats
extends AnnotatedStandardMBean
implements PropertyIndexStatsMBean {
    @Reference
    private NodeStore store;
    private Registration reg;

    public PropertyIndexStats() {
        super(PropertyIndexStatsMBean.class);
    }

    @Activate
    private void activate(BundleContext context) {
        this.reg = WhiteboardUtils.registerMBean(new OsgiWhiteboard(context), PropertyIndexStatsMBean.class, this, "PropertyIndexStats", "Property Index statistics");
    }

    @Deactivate
    private void deactivate() {
        if (this.reg != null) {
            this.reg.unregister();
        }
    }

    @Override
    public TabularData getStatsForAllIndexes(String path, int maxValueCount, int maxDepth, int maxPathCount) throws OpenDataException {
        String indexRootPath = PathUtils.concat(path, "oak:index");
        NodeState idxRoot = NodeStateUtils.getNode(this.store.getRoot(), indexRootPath);
        TabularType tt = new TabularType(PropertyIndexStats.class.getName(), "Property Index Stats", PropertyIndexStats.getType(), new String[]{"path"});
        TabularDataSupport tds = new TabularDataSupport(tt);
        for (ChildNodeEntry childNodeEntry : idxRoot.getChildNodeEntries()) {
            if (!"property".equals(childNodeEntry.getNodeState().getString("type"))) continue;
            CompositeData stats = this.getStatsForIndex(PathUtils.concat(indexRootPath, childNodeEntry.getName()), childNodeEntry.getNodeState(), maxValueCount, maxDepth, maxPathCount);
            tds.put(stats);
        }
        return tds;
    }

    @Override
    public CompositeData getStatsForSpecificIndex(String path, int maxValueCount, int maxDepth, int maxPathCount) throws OpenDataException {
        NodeState idx = NodeStateUtils.getNode(this.store.getRoot(), path);
        return this.getStatsForIndex(path, idx, maxValueCount, maxDepth, maxPathCount);
    }

    private CompositeData getStatsForIndex(String path, NodeState idx, int maxValueCount, int maxDepth, int maxPathCount) throws OpenDataException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("path", path);
        result.put("values", new String[0]);
        result.put("paths", new String[0]);
        result.put("valueCount", -1L);
        result.put("pathCount", -1);
        result.put("maxPathCount", maxPathCount);
        result.put("maxDepth", maxDepth);
        result.put("maxValueCount", maxValueCount);
        String status = "No index found at path " + path;
        NodeState data = idx.getChildNode(":index");
        if (data.exists()) {
            if (idx.getBoolean("unique")) {
                status = "stats not supported for unique indexes";
            } else {
                long childNodeCount = data.getChildNodeCount(maxValueCount);
                if (childNodeCount == Long.MAX_VALUE || childNodeCount > (long)maxValueCount) {
                    status = String.format("stats cannot be determined as number of values exceed the max limit of [%d]. Estimated value count [%d]", maxValueCount, childNodeCount);
                } else {
                    String[] values = (String[])Iterables.toArray((Iterable)Iterables.limit(data.getChildNodeNames(), (int)maxValueCount), String.class);
                    String[] paths = this.determineIndexedPaths(data.getChildNodeEntries(), maxDepth, maxPathCount);
                    result.put("values", values);
                    result.put("paths", paths);
                    result.put("pathCount", paths.length);
                    status = "Result determined and above path list can be safely used based on current indexed data";
                }
                result.put("valueCount", childNodeCount);
            }
        }
        result.put("status", status);
        return new CompositeDataSupport(PropertyIndexStats.getType(), result);
    }

    private String[] determineIndexedPaths(Iterable<? extends ChildNodeEntry> values, final int maxDepth, int maxPathCount) {
        HashSet paths = Sets.newHashSet();
        HashSet intermediatePaths = Sets.newHashSet();
        int maxPathLimitBreachedAtLevel = -1;
        block0: for (ChildNodeEntry childNodeEntry : values) {
            Tree t = TreeFactory.createReadOnlyTree(childNodeEntry.getNodeState());
            TreeTraverser<Tree> traverser = new TreeTraverser<Tree>(){

                public Iterable<Tree> children(@Nonnull Tree root) {
                    if (PathUtils.getDepth(root.getPath()) >= maxDepth) {
                        return Collections.emptyList();
                    }
                    return root.getChildren();
                }
            };
            for (Tree node : traverser.breadthFirstTraversal((Object)t)) {
                PropertyState matchState = node.getProperty("match");
                boolean match = matchState == null ? false : matchState.getValue(Type.BOOLEAN);
                int depth = PathUtils.getDepth(node.getPath());
                if (depth < maxDepth && !match) {
                    intermediatePaths.add(node.getPath());
                    continue;
                }
                if (paths.size() < maxPathCount) {
                    paths.add(node.getPath());
                    continue;
                }
                maxPathLimitBreachedAtLevel = depth;
                break block0;
            }
        }
        if (maxPathLimitBreachedAtLevel < 0) {
            return (String[])Iterables.toArray((Iterable)paths, String.class);
        }
        HashSet result = Sets.newHashSet();
        int n = maxPathLimitBreachedAtLevel - 1;
        if (n > 0) {
            for (String path : intermediatePaths) {
                int pathDepth = PathUtils.getDepth(path);
                if (pathDepth != n) continue;
                result.add(path);
            }
        }
        return (String[])Iterables.toArray((Iterable)result, String.class);
    }

    private static CompositeType getType() throws OpenDataException {
        return new CompositeType("PropertyIndexStats", "Property index related stats", new String[]{"path", "values", "paths", "valueCount", "status", "pathCount", "maxPathCount", "maxDepth", "maxValueCount"}, new String[]{"path", "values", "paths", "valueCount", "status", "pathCount", "maxPathCount", "maxDepth", "maxValueCount"}, new OpenType[]{SimpleType.STRING, new ArrayType(SimpleType.STRING, false), new ArrayType(SimpleType.STRING, false), SimpleType.LONG, SimpleType.STRING, SimpleType.INTEGER, SimpleType.INTEGER, SimpleType.INTEGER, SimpleType.INTEGER});
    }
}

