/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.importer;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.jackrabbit.oak.plugins.index.importer.PropUtils;

public class IndexerInfo {
    public static final String INDEXER_META = "indexer-info.properties";
    public static final String INDEX_METADATA_FILE_NAME = "index-details.txt";
    public static final String PROP_INDEX_PATH = "indexPath";
    public final String checkpoint;
    private final File rootDir;

    public IndexerInfo(File rootDir, String checkpoint) {
        this.rootDir = rootDir;
        this.checkpoint = (String)Preconditions.checkNotNull((Object)checkpoint);
    }

    public void save() throws IOException {
        File infoFile = new File(this.rootDir, INDEXER_META);
        Properties p = new Properties();
        p.setProperty("checkpoint", this.checkpoint);
        PropUtils.writeTo(p, infoFile, "Indexer info");
    }

    public Map<String, File> getIndexes() throws IOException {
        ImmutableMap.Builder indexes = ImmutableMap.builder();
        for (File dir : this.rootDir.listFiles((FileFilter)DirectoryFileFilter.DIRECTORY)) {
            Properties p;
            String indexPath;
            File metaFile = new File(dir, INDEX_METADATA_FILE_NAME);
            if (!metaFile.exists() || (indexPath = (p = PropUtils.loadFromFile(metaFile)).getProperty(PROP_INDEX_PATH)) == null) continue;
            indexes.put((Object)indexPath, (Object)dir);
        }
        return indexes.build();
    }

    public static IndexerInfo fromDirectory(File rootDir) throws IOException {
        File infoFile = new File(rootDir, INDEXER_META);
        Preconditions.checkArgument((boolean)infoFile.exists(), (String)"No [%s] file found in [%s]. Not a valid exported index directory", (Object[])new Object[]{INDEXER_META, rootDir.getAbsolutePath()});
        Properties p = PropUtils.loadFromFile(infoFile);
        return new IndexerInfo(rootDir, PropUtils.getProp(p, "checkpoint"));
    }
}

