/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.jcr.session;

import com.google.common.collect.Lists;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.annotation.Nonnull;
import javax.jcr.AccessDeniedException;
import javax.jcr.Binary;
import javax.jcr.ItemNotFoundException;
import javax.jcr.ItemVisitor;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.ValueFormatException;
import javax.jcr.nodetype.PropertyDefinition;
import javax.jcr.version.VersionException;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.jcr.delegate.NodeDelegate;
import org.apache.jackrabbit.oak.jcr.delegate.PropertyDelegate;
import org.apache.jackrabbit.oak.jcr.session.ItemImpl;
import org.apache.jackrabbit.oak.jcr.session.NodeImpl;
import org.apache.jackrabbit.oak.jcr.session.SessionContext;
import org.apache.jackrabbit.oak.jcr.session.operation.PropertyOperation;
import org.apache.jackrabbit.oak.jcr.session.operation.SessionOperation;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.plugins.value.jcr.ValueFactoryImpl;
import org.apache.jackrabbit.value.ValueHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyImpl
extends ItemImpl<PropertyDelegate>
implements Property {
    private static final Logger LOG = LoggerFactory.getLogger(PropertyImpl.class);
    private static final Value[] NO_VALUES = new Value[0];

    PropertyImpl(PropertyDelegate dlg, SessionContext sessionContext) {
        super(dlg, sessionContext);
    }

    public boolean isNode() {
        return false;
    }

    @Nonnull
    public Node getParent() throws RepositoryException {
        return this.perform(new PropertyOperation<Node>((PropertyDelegate)this.dlg, "getParent"){

            @Override
            @Nonnull
            public Node perform() throws RepositoryException {
                NodeDelegate parent = this.property.getParent();
                if (parent == null) {
                    throw new AccessDeniedException();
                }
                return NodeImpl.createNode(parent, PropertyImpl.this.sessionContext);
            }
        });
    }

    public boolean isNew() {
        return this.sessionDelegate.safePerform(new PropertyOperation<Boolean>((PropertyDelegate)this.dlg, "isNew"){

            @Override
            @Nonnull
            public Boolean perform() {
                return this.property.getStatus() == Tree.Status.NEW;
            }
        });
    }

    public boolean isModified() {
        return this.sessionDelegate.safePerform(new PropertyOperation<Boolean>((PropertyDelegate)this.dlg, "isModified"){

            @Override
            @Nonnull
            public Boolean perform() {
                return this.property.getStatus() == Tree.Status.MODIFIED;
            }
        });
    }

    public void remove() throws RepositoryException {
        this.sessionDelegate.performVoid((SessionOperation<Void>)new ItemImpl.ItemWriteOperation<Void>("remove"){

            @Override
            public void checkPreconditions() throws RepositoryException {
                super.checkPreconditions();
                if (!PropertyImpl.this.getParent().isCheckedOut() && PropertyImpl.this.getDefinition().getOnParentVersion() != 5) {
                    throw new VersionException("Cannot set property. Node is checked in.");
                }
            }

            @Override
            public void performVoid() {
                ((PropertyDelegate)PropertyImpl.this.dlg).remove();
            }

            @Override
            public String toString() {
                return String.format("Removing property [%s/%s] ", ((PropertyDelegate)PropertyImpl.this.dlg).getPath(), ((PropertyDelegate)PropertyImpl.this.dlg).getName());
            }
        });
    }

    public void accept(ItemVisitor visitor) throws RepositoryException {
        visitor.visit((Property)this);
    }

    public void setValue(Value value) throws RepositoryException {
        if (value == null) {
            this.remove();
        } else {
            this.internalSetValue(value);
        }
    }

    public void setValue(Value[] values) throws RepositoryException {
        if (values == null) {
            this.remove();
        } else {
            this.internalSetValue(values);
        }
    }

    public void setValue(String value) throws RepositoryException {
        if (value == null) {
            this.remove();
        } else {
            this.setValue(this.getValueFactory().createValue(value));
        }
    }

    public void setValue(String[] strings) throws RepositoryException {
        if (strings == null) {
            this.remove();
        } else {
            ValueFactory factory = this.getValueFactory();
            Value[] values = new Value[strings.length];
            for (int i = 0; i < strings.length; ++i) {
                if (strings[i] == null) continue;
                values[i] = factory.createValue(strings[i]);
            }
            this.internalSetValue(values);
        }
    }

    public void setValue(InputStream value) throws RepositoryException {
        if (value == null) {
            this.remove();
        } else {
            this.setValue(this.getValueFactory().createValue(value));
        }
    }

    public void setValue(Binary value) throws RepositoryException {
        if (value == null) {
            this.remove();
        } else {
            this.setValue(this.getValueFactory().createValue(value));
        }
    }

    public void setValue(long value) throws RepositoryException {
        this.setValue(this.getValueFactory().createValue(value));
    }

    public void setValue(double value) throws RepositoryException {
        this.setValue(this.getValueFactory().createValue(value));
    }

    public void setValue(BigDecimal value) throws RepositoryException {
        if (value == null) {
            this.remove();
        } else {
            this.setValue(this.getValueFactory().createValue(value));
        }
    }

    public void setValue(Calendar value) throws RepositoryException {
        if (value == null) {
            this.remove();
        } else {
            this.setValue(this.getValueFactory().createValue(value));
        }
    }

    public void setValue(boolean value) throws RepositoryException {
        this.setValue(this.getValueFactory().createValue(value));
    }

    public void setValue(Node value) throws RepositoryException {
        if (value == null) {
            this.remove();
        } else {
            this.setValue(this.getValueFactory().createValue(value));
        }
    }

    @Nonnull
    public Value getValue() throws RepositoryException {
        return this.perform(new PropertyOperation<Value>((PropertyDelegate)this.dlg, "getValue"){

            @Override
            @Nonnull
            public Value perform() throws RepositoryException {
                return ValueFactoryImpl.createValue(this.property.getSingleState(), (NamePathMapper)PropertyImpl.this.sessionContext);
            }
        });
    }

    @Nonnull
    public Value[] getValues() throws RepositoryException {
        return this.perform(new PropertyOperation<List<Value>>((PropertyDelegate)this.dlg, "getValues"){

            @Override
            @Nonnull
            public List<Value> perform() throws RepositoryException {
                return ValueFactoryImpl.createValues(this.property.getMultiState(), PropertyImpl.this.sessionContext);
            }
        }).toArray(NO_VALUES);
    }

    @Nonnull
    public String getString() throws RepositoryException {
        return this.getValue().getString();
    }

    @Nonnull
    public InputStream getStream() throws RepositoryException {
        return this.getValue().getStream();
    }

    @Nonnull
    public Binary getBinary() throws RepositoryException {
        return this.getValue().getBinary();
    }

    public long getLong() throws RepositoryException {
        return this.getValue().getLong();
    }

    public double getDouble() throws RepositoryException {
        return this.getValue().getDouble();
    }

    @Nonnull
    public BigDecimal getDecimal() throws RepositoryException {
        return this.getValue().getDecimal();
    }

    @Nonnull
    public Calendar getDate() throws RepositoryException {
        return this.getValue().getDate();
    }

    public boolean getBoolean() throws RepositoryException {
        return this.getValue().getBoolean();
    }

    @Nonnull
    public Node getNode() throws RepositoryException {
        return this.perform(new PropertyOperation<Node>((PropertyDelegate)this.dlg, "getNode"){

            @Override
            @Nonnull
            public Node perform() throws RepositoryException {
                Value value = PropertyImpl.this.getValue();
                switch (value.getType()) {
                    case 9: 
                    case 10: {
                        return PropertyImpl.this.getSession().getNodeByIdentifier(value.getString());
                    }
                    case 7: 
                    case 8: {
                        String path = value.getString();
                        if (path.startsWith("[") && path.endsWith("]")) {
                            String identifier = path.substring(1, path.length() - 1);
                            return PropertyImpl.this.getSession().getNodeByIdentifier(identifier);
                        }
                        try {
                            return path.charAt(0) == '/' ? PropertyImpl.this.getSession().getNode(path) : PropertyImpl.this.getParent().getNode(path);
                        }
                        catch (PathNotFoundException e) {
                            throw new ItemNotFoundException(path);
                        }
                    }
                    case 1: {
                        try {
                            Value refValue = ValueHelper.convert(value, 9, PropertyImpl.this.getValueFactory());
                            return PropertyImpl.this.getSession().getNodeByIdentifier(refValue.getString());
                        }
                        catch (ItemNotFoundException e) {
                            throw e;
                        }
                        catch (RepositoryException e) {
                            Value pathValue = ValueHelper.convert(value, 8, PropertyImpl.this.getValueFactory());
                            String path = pathValue.getString();
                            try {
                                return path.charAt(0) == '/' ? PropertyImpl.this.getSession().getNode(path) : PropertyImpl.this.getParent().getNode(path);
                            }
                            catch (PathNotFoundException e1) {
                                throw new ItemNotFoundException(pathValue.getString());
                            }
                        }
                    }
                }
                throw new ValueFormatException("Property value cannot be converted to a PATH, REFERENCE or WEAKREFERENCE");
            }
        });
    }

    @Nonnull
    public Property getProperty() throws RepositoryException {
        return this.perform(new PropertyOperation<Property>((PropertyDelegate)this.dlg, "getProperty"){

            @Override
            @Nonnull
            public Property perform() throws RepositoryException {
                Value value = PropertyImpl.this.getValue();
                Value pathValue = ValueHelper.convert(value, 8, PropertyImpl.this.getValueFactory());
                String path = pathValue.getString();
                try {
                    return path.charAt(0) == '/' ? PropertyImpl.this.getSession().getProperty(path) : PropertyImpl.this.getParent().getProperty(path);
                }
                catch (PathNotFoundException e) {
                    throw new ItemNotFoundException(path);
                }
            }
        });
    }

    public long getLength() throws RepositoryException {
        return PropertyImpl.getLength(this.getValue());
    }

    @Nonnull
    public long[] getLengths() throws RepositoryException {
        Value[] values = this.getValues();
        long[] lengths = new long[values.length];
        for (int i = 0; i < values.length; ++i) {
            lengths[i] = PropertyImpl.getLength(values[i]);
        }
        return lengths;
    }

    @Nonnull
    public PropertyDefinition getDefinition() throws RepositoryException {
        return this.perform(new PropertyOperation<PropertyDefinition>((PropertyDelegate)this.dlg, "getDefinition"){

            @Override
            @Nonnull
            public PropertyDefinition perform() throws RepositoryException {
                return PropertyImpl.this.getNodeTypeManager().getDefinition(this.property.getParent().getTree(), this.property.getPropertyState(), true);
            }
        });
    }

    public int getType() throws RepositoryException {
        return this.perform(new PropertyOperation<Integer>((PropertyDelegate)this.dlg, "getType"){

            @Override
            @Nonnull
            public Integer perform() throws RepositoryException {
                return this.property.getPropertyState().getType().tag();
            }
        });
    }

    public boolean isMultiple() throws RepositoryException {
        return this.perform(new PropertyOperation<Boolean>((PropertyDelegate)this.dlg, "isMultiple"){

            @Override
            @Nonnull
            public Boolean perform() throws RepositoryException {
                return this.property.getPropertyState().isArray();
            }
        });
    }

    private static long getLength(Value value) throws RepositoryException {
        if (value.getType() == 2) {
            return value.getBinary().getSize();
        }
        return value.getString().length();
    }

    private void internalSetValue(final @Nonnull Value value) throws RepositoryException {
        this.sessionDelegate.performVoid((SessionOperation<Void>)new ItemImpl.ItemWriteOperation<Void>("internalSetValue"){

            @Override
            public void checkPreconditions() throws RepositoryException {
                super.checkPreconditions();
                if (!PropertyImpl.this.getParent().isCheckedOut() && PropertyImpl.this.getDefinition().getOnParentVersion() != 5) {
                    throw new VersionException("Cannot set property. Node is checked in.");
                }
            }

            @Override
            public void performVoid() throws RepositoryException {
                Type<?> type = ((PropertyDelegate)PropertyImpl.this.dlg).getPropertyState().getType();
                if (type.isArray()) {
                    throw new ValueFormatException("This is a multi-valued property");
                }
                Value converted = ValueHelper.convert(value, type.tag(), PropertyImpl.this.getValueFactory());
                ((PropertyDelegate)PropertyImpl.this.dlg).setState(PropertyImpl.this.createSingleState(((PropertyDelegate)PropertyImpl.this.dlg).getName(), converted, type));
            }

            @Override
            public String toString() {
                return String.format("Setting property [%s/%s]", ((PropertyDelegate)PropertyImpl.this.dlg).getPath(), ((PropertyDelegate)PropertyImpl.this.dlg).getName());
            }
        });
    }

    private void internalSetValue(final @Nonnull Value[] values) throws RepositoryException {
        if (values.length > 1000) {
            LOG.warn("Large multi valued property [{}] detected ({} values).", (Object)((PropertyDelegate)this.dlg).getPath(), (Object)values.length);
        }
        this.sessionDelegate.performVoid((SessionOperation<Void>)new ItemImpl.ItemWriteOperation<Void>("internalSetValue"){

            @Override
            public void checkPreconditions() throws RepositoryException {
                super.checkPreconditions();
                if (!PropertyImpl.this.getParent().isCheckedOut() && PropertyImpl.this.getDefinition().getOnParentVersion() != 5) {
                    throw new VersionException("Cannot set property. Node is checked in.");
                }
            }

            @Override
            public void performVoid() throws RepositoryException {
                Type<?> type = ((PropertyDelegate)PropertyImpl.this.dlg).getPropertyState().getType();
                if (!type.isArray()) {
                    throw new ValueFormatException("This is a single-valued property");
                }
                ArrayList converted = Lists.newArrayListWithCapacity((int)values.length);
                ValueFactory factory = PropertyImpl.this.getValueFactory();
                for (Value value : values) {
                    if (value == null) continue;
                    converted.add(ValueHelper.convert(value, type.tag(), factory));
                }
                ((PropertyDelegate)PropertyImpl.this.dlg).setState(PropertyImpl.this.createMultiState(((PropertyDelegate)PropertyImpl.this.dlg).getName(), converted, type));
            }

            @Override
            public String toString() {
                return String.format("Setting property [%s/%s]", ((PropertyDelegate)PropertyImpl.this.dlg).getPath(), ((PropertyDelegate)PropertyImpl.this.dlg).getName());
            }
        });
    }
}

