/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.cache;

import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.Weigher;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.jackrabbit.oak.cache.AbstractCacheStats;

public class CacheStats
extends AbstractCacheStats {
    private final Cache<Object, Object> cache;
    private final Weigher<Object, Object> weigher;
    private final long maxWeight;

    public CacheStats(@Nonnull Cache<?, ?> cache, @Nonnull String name, @Nullable Weigher<?, ?> weigher, long maxWeight) {
        super(name);
        this.cache = (Cache)Preconditions.checkNotNull(cache);
        this.weigher = weigher;
        this.maxWeight = maxWeight;
    }

    @Override
    protected com.google.common.cache.CacheStats getCurrentStats() {
        return this.cache.stats();
    }

    @Override
    public long getElementCount() {
        return this.cache.size();
    }

    @Override
    public long estimateCurrentWeight() {
        if (this.weigher == null) {
            return -1L;
        }
        long size = 0L;
        for (Map.Entry e : this.cache.asMap().entrySet()) {
            Object k = e.getKey();
            Object v = e.getValue();
            size += (long)this.weigher.weigh(k, v);
        }
        return size;
    }

    @Override
    public long getMaxTotalWeight() {
        return this.maxWeight;
    }
}

