/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.principal;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.api.security.principal.PrincipalManager;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.spi.security.CompositeConfiguration;
import org.apache.jackrabbit.oak.spi.security.SecurityProvider;
import org.apache.jackrabbit.oak.spi.security.principal.CompositePrincipalProvider;
import org.apache.jackrabbit.oak.spi.security.principal.EmptyPrincipalProvider;
import org.apache.jackrabbit.oak.spi.security.principal.PrincipalConfiguration;
import org.apache.jackrabbit.oak.spi.security.principal.PrincipalManagerImpl;
import org.apache.jackrabbit.oak.spi.security.principal.PrincipalProvider;

public class CompositePrincipalConfiguration
extends CompositeConfiguration<PrincipalConfiguration>
implements PrincipalConfiguration {
    public CompositePrincipalConfiguration() {
        super("org.apache.jackrabbit.oak.principal");
    }

    public CompositePrincipalConfiguration(@Nonnull SecurityProvider securityProvider) {
        super("org.apache.jackrabbit.oak.principal", securityProvider);
    }

    @Override
    @Nonnull
    public PrincipalManager getPrincipalManager(Root root, NamePathMapper namePathMapper) {
        return new PrincipalManagerImpl(this.getPrincipalProvider(root, namePathMapper));
    }

    @Override
    @Nonnull
    public PrincipalProvider getPrincipalProvider(Root root, NamePathMapper namePathMapper) {
        List configurations = this.getConfigurations();
        switch (configurations.size()) {
            case 0: {
                return EmptyPrincipalProvider.INSTANCE;
            }
            case 1: {
                return ((PrincipalConfiguration)configurations.get(0)).getPrincipalProvider(root, namePathMapper);
            }
        }
        ArrayList<PrincipalProvider> pps = new ArrayList<PrincipalProvider>(configurations.size());
        for (PrincipalConfiguration principalConfig : configurations) {
            PrincipalProvider principalProvider = principalConfig.getPrincipalProvider(root, namePathMapper);
            if (principalProvider instanceof EmptyPrincipalProvider) continue;
            pps.add(principalProvider);
        }
        return CompositePrincipalProvider.of(pps);
    }
}

