/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.commit;

import com.google.common.base.Preconditions;
import java.io.Closeable;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.commit.CompositeObserver;
import org.apache.jackrabbit.oak.spi.commit.Observable;
import org.apache.jackrabbit.oak.spi.commit.Observer;
import org.apache.jackrabbit.oak.spi.state.NodeState;

public class ChangeDispatcher
implements Observable,
Observer {
    private final CompositeObserver observers = new CompositeObserver();
    @Nonnull
    private NodeState root;

    public ChangeDispatcher(@Nonnull NodeState root) {
        this.root = (NodeState)Preconditions.checkNotNull((Object)root);
    }

    @Override
    @Nonnull
    public synchronized Closeable addObserver(final Observer observer) {
        observer.contentChanged(this.root, CommitInfo.EMPTY_EXTERNAL);
        this.observers.addObserver(observer);
        return new Closeable(){

            @Override
            public void close() {
                ChangeDispatcher.this.observers.removeObserver(observer);
            }
        };
    }

    @Override
    public synchronized void contentChanged(@Nonnull NodeState root, @Nonnull CommitInfo info) {
        Preconditions.checkNotNull((Object)root);
        Preconditions.checkNotNull((Object)info);
        this.observers.contentChanged(root, info);
        this.root = root;
    }
}

