/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.user;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.jcr.AccessDeniedException;
import javax.jcr.nodetype.ConstraintViolationException;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.tree.TreeUtil;
import org.apache.jackrabbit.oak.security.user.PasswordHistoryException;
import org.apache.jackrabbit.oak.spi.security.ConfigurationParameters;
import org.apache.jackrabbit.oak.spi.security.user.UserConstants;
import org.apache.jackrabbit.oak.spi.security.user.util.PasswordUtil;

final class PasswordHistory
implements UserConstants {
    private static final int HISTORY_MAX_SIZE = 1000;
    private final int maxSize;
    private final boolean isEnabled;

    public PasswordHistory(@Nonnull ConfigurationParameters config) {
        this.maxSize = Math.min(1000, config.getConfigValue("passwordHistorySize", 0));
        this.isEnabled = this.maxSize > 0;
    }

    boolean updatePasswordHistory(@Nonnull Tree userTree, @Nonnull String password) throws ConstraintViolationException, AccessDeniedException {
        boolean updated = false;
        if (this.isEnabled) {
            this.checkPasswordInHistory(userTree, password);
            this.shiftPasswordHistory(userTree);
            updated = true;
        }
        return updated;
    }

    private void shiftPasswordHistory(@Nonnull Tree userTree) throws AccessDeniedException {
        String currentPasswordHash = TreeUtil.getString(userTree, "rep:password");
        if (currentPasswordHash != null) {
            Tree passwordTree = PasswordHistory.getPasswordTree(userTree, true);
            PropertyState historyProp = passwordTree.getProperty("rep:pwdHistory");
            List historyEntries = historyProp == null ? new ArrayList() : Lists.newArrayList(historyProp.getValue(Type.STRINGS));
            historyEntries.add(0, currentPasswordHash);
            if (historyEntries.size() > this.maxSize) {
                historyEntries = historyEntries.subList(0, this.maxSize);
            }
            passwordTree.setProperty("rep:pwdHistory", historyEntries, Type.STRINGS);
        }
    }

    private void checkPasswordInHistory(@Nonnull Tree userTree, @Nonnull String newPassword) throws ConstraintViolationException, AccessDeniedException {
        PropertyState pwHistoryProperty;
        if (PasswordUtil.isSame(TreeUtil.getString(userTree, "rep:password"), newPassword)) {
            throw new PasswordHistoryException("New password is identical to the current password.");
        }
        Tree pwTree = PasswordHistory.getPasswordTree(userTree, false);
        if (pwTree.exists() && (pwHistoryProperty = pwTree.getProperty("rep:pwdHistory")) != null) {
            for (String historyPwHash : Iterables.limit(pwHistoryProperty.getValue(Type.STRINGS), (int)this.maxSize)) {
                if (!PasswordUtil.isSame(historyPwHash, newPassword)) continue;
                throw new PasswordHistoryException("New password was found in password history.");
            }
        }
    }

    @Nonnull
    private static Tree getPasswordTree(@Nonnull Tree userTree, boolean doCreate) throws AccessDeniedException {
        if (doCreate) {
            return TreeUtil.getOrAddChild(userTree, "rep:pwd", "rep:Password");
        }
        return userTree.getChild("rep:pwd");
    }
}

