/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.query.ast;

import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.jcr.PropertyType;
import org.apache.jackrabbit.oak.api.PropertyValue;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.query.SQL2Parser;
import org.apache.jackrabbit.oak.query.ast.AstVisitor;
import org.apache.jackrabbit.oak.query.ast.DynamicOperandImpl;
import org.apache.jackrabbit.oak.query.ast.Operator;
import org.apache.jackrabbit.oak.query.ast.OrderingImpl;
import org.apache.jackrabbit.oak.query.ast.PropertyExistenceImpl;
import org.apache.jackrabbit.oak.query.ast.SelectorImpl;
import org.apache.jackrabbit.oak.query.ast.SourceImpl;
import org.apache.jackrabbit.oak.query.index.FilterImpl;
import org.apache.jackrabbit.oak.spi.query.Filter;
import org.apache.jackrabbit.oak.spi.query.QueryIndex;

public class PropertyValueImpl
extends DynamicOperandImpl {
    private final String selectorName;
    private final String propertyName;
    private final int propertyType;
    private SelectorImpl selector;

    public PropertyValueImpl(String selectorName, String propertyName) {
        this(selectorName, propertyName, null);
    }

    public PropertyValueImpl(String selectorName, String propertyName, String propertyType) {
        this.selectorName = selectorName;
        this.propertyName = propertyName;
        this.propertyType = propertyType == null ? 0 : SQL2Parser.getPropertyTypeFromName(propertyType);
    }

    public String getSelectorName() {
        return this.selectorName;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    @Override
    boolean accept(AstVisitor v) {
        return v.visit(this);
    }

    public String toString() {
        String s = this.quote(this.selectorName) + '.' + this.quote(this.propertyName);
        if (this.propertyType != 0) {
            s = "property(" + s + ", '" + PropertyType.nameFromValue((int)this.propertyType).toLowerCase(Locale.ENGLISH) + "')";
        }
        return s;
    }

    @Override
    public boolean supportsRangeConditions() {
        return !this.propertyName.equals("jcr:path");
    }

    @Override
    public PropertyExistenceImpl getPropertyExistence() {
        if (this.propertyName.equals("*")) {
            return null;
        }
        return new PropertyExistenceImpl(this.selector, this.selectorName, this.propertyName);
    }

    @Override
    public Set<SelectorImpl> getSelectors() {
        return Collections.singleton(this.selector);
    }

    @Override
    public PropertyValue currentProperty() {
        PropertyValue p = this.propertyType == 0 ? this.selector.currentProperty(this.propertyName) : this.selector.currentProperty(this.propertyName, this.propertyType);
        return p;
    }

    public void bindSelector(SourceImpl source) {
        this.selector = source.getExistingSelector(this.selectorName);
    }

    @Override
    public void restrict(FilterImpl f, Operator operator, PropertyValue v) {
        if (f.getSelector().equals(this.selector)) {
            String pn = this.normalizePropertyName(this.propertyName);
            if (pn.equals("jcr:path")) {
                if (operator == Operator.EQUAL) {
                    f.restrictPath(v.getValue(Type.STRING), Filter.PathRestriction.EXACT);
                }
            } else if (operator == Operator.NOT_EQUAL && v != null) {
                f.restrictProperty(pn, Operator.NOT_EQUAL, null, this.propertyType);
            } else {
                f.restrictProperty(pn, operator, v, this.propertyType);
            }
        }
    }

    @Override
    public void restrictList(FilterImpl f, List<PropertyValue> list) {
        if (f.getSelector().equals(this.selector)) {
            String pn = this.normalizePropertyName(this.propertyName);
            f.restrictPropertyAsList(pn, list);
        }
    }

    @Override
    public String getFunction(SelectorImpl s) {
        if (!s.equals(this.selector)) {
            return null;
        }
        String pn = this.normalizePropertyName(this.propertyName);
        return "@" + pn;
    }

    @Override
    public boolean canRestrictSelector(SelectorImpl s) {
        return s.equals(this.selector);
    }

    @Override
    int getPropertyType() {
        return this.propertyType;
    }

    @Override
    public PropertyValueImpl createCopy() {
        return new PropertyValueImpl(this.selectorName, this.propertyName);
    }

    @Override
    public QueryIndex.OrderEntry getOrderEntry(SelectorImpl s, OrderingImpl o) {
        if (!s.equals(this.selector)) {
            return null;
        }
        String pn = this.normalizePropertyName(this.propertyName);
        return new QueryIndex.OrderEntry(pn, Type.UNDEFINED, o.isDescending() ? QueryIndex.OrderEntry.Order.DESCENDING : QueryIndex.OrderEntry.Order.ASCENDING);
    }
}

