/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.migration.report;

import com.google.common.collect.EvictingQueue;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.plugins.migration.report.PeriodicReporter;
import org.apache.jackrabbit.oak.plugins.migration.report.ReportingNodeState;
import org.slf4j.Logger;

public class LoggingReporter
extends PeriodicReporter {
    private final Logger logger;
    private final String verb;
    private final EvictingQueue lastPaths = EvictingQueue.create((int)100);

    public LoggingReporter(Logger logger, int nodeLogInterval, int propertyLogInterval) {
        this(logger, "Loading", nodeLogInterval, propertyLogInterval);
    }

    public LoggingReporter(Logger logger, String verb, int nodeLogInterval, int propertyLogInterval) {
        super(nodeLogInterval, propertyLogInterval);
        this.logger = logger;
        this.verb = verb;
    }

    @Override
    protected void reportPeriodicNode(long count, @Nonnull ReportingNodeState nodeState) {
        this.logger.info("{} node #{}: {}", new Object[]{this.verb, count, nodeState.getPath()});
    }

    @Override
    protected void reportPeriodicProperty(long count, @Nonnull ReportingNodeState parent, @Nonnull String propertyName) {
        this.logger.info("{} properties #{}: {}", new Object[]{this.verb, count, PathUtils.concat(parent.getPath(), propertyName)});
    }

    @Override
    protected boolean skipNodeState(@Nonnull ReportingNodeState nodeState) {
        String path = nodeState.getPath();
        if (this.lastPaths.contains((Object)path)) {
            return true;
        }
        this.lastPaths.add((Object)path);
        return false;
    }
}

