/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.property;

import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.plugins.index.ContextAwareCallback;
import org.apache.jackrabbit.oak.plugins.index.IndexEditorProvider;
import org.apache.jackrabbit.oak.plugins.index.IndexUpdateCallback;
import org.apache.jackrabbit.oak.plugins.index.property.OrderedIndex;
import org.apache.jackrabbit.oak.spi.commit.Editor;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={IndexEditorProvider.class})
public class OrderedPropertyIndexEditorProvider
implements IndexEditorProvider,
OrderedIndex {
    private static final Logger LOG = LoggerFactory.getLogger(OrderedPropertyIndexEditorProvider.class);
    private int hits;
    private static int threshold = 10000;

    @Override
    @CheckForNull
    public Editor getIndexEditor(@Nonnull String type, @Nonnull NodeBuilder definition, @Nonnull NodeState root, @Nonnull IndexUpdateCallback callback) throws CommitFailedException {
        if ("ordered".equals(type) && this.hit() % threshold == 0) {
            if (callback instanceof ContextAwareCallback) {
                LOG.warn("Ordered Index has been deprecated since Oak 1.1.8. Please replace the index definition ({}) with Lucene Property index and remove the index providers from the repository. See docs at http://jackrabbit.apache.org/oak/docs", (Object)((ContextAwareCallback)callback).getIndexingContext().getIndexPath());
            } else {
                LOG.warn("Ordered Index has been deprecated since Oak 1.1.8. Please replace the index definition ({}) with Lucene Property index and remove the index providers from the repository. See docs at http://jackrabbit.apache.org/oak/docs", (Object)definition);
            }
        }
        return null;
    }

    private synchronized int hit() {
        return this.hits++;
    }

    static void setThreshold(int t) {
        threshold = t;
    }
}

