/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.property;

import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.jackrabbit.oak.spi.state.NodeState;

public interface OrderedIndex {
    public static final String DEPRECATION_MESSAGE = "Ordered Index has been deprecated since Oak 1.1.8. Please replace the index definition ({}) with Lucene Property index and remove the index providers from the repository. See docs at http://jackrabbit.apache.org/oak/docs";
    public static final int TRACK_DEPRECATION_EVERY = 10000;
    public static final String TYPE = "ordered";
    public static final String DIRECTION = "direction";
    public static final OrderDirection DEFAULT_DIRECTION = OrderDirection.ASC;

    public static enum OrderDirection {
        ASC("ascending"),
        DESC("descending");

        private final String direction;

        private OrderDirection(String direction) {
            this.direction = direction;
        }

        public String getDirection() {
            return this.direction;
        }

        @Nullable
        @CheckForNull
        public static OrderDirection fromString(@Nonnull String direction) {
            for (OrderDirection d : OrderDirection.values()) {
                if (!d.getDirection().equalsIgnoreCase(direction)) continue;
                return d;
            }
            return null;
        }

        public static OrderDirection fromIndexMeta(NodeState indexMeta) {
            OrderDirection direction = ASC;
            if (indexMeta != null && DESC.getDirection().equals(indexMeta.getString(OrderedIndex.DIRECTION))) {
                direction = DESC;
            }
            return direction;
        }

        public static boolean isDescending(NodeState indexMeta) {
            return DESC.equals((Object)OrderDirection.fromIndexMeta(indexMeta));
        }

        public boolean isAscending() {
            return ASC.equals((Object)this);
        }

        public boolean isDescending() {
            return DESC.equals((Object)this);
        }

        public static boolean isAscending(NodeState indexMeta) {
            return ASC.equals((Object)OrderDirection.fromIndexMeta(indexMeta));
        }
    }
}

