/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.blob.migration;

import java.util.HashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import javax.annotation.Nonnull;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.jackrabbit.oak.api.jmx.RepositoryManagementMBean;
import org.apache.jackrabbit.oak.commons.jmx.AnnotatedStandardMBean;
import org.apache.jackrabbit.oak.commons.jmx.ManagementOperation;
import org.apache.jackrabbit.oak.osgi.OsgiWhiteboard;
import org.apache.jackrabbit.oak.plugins.blob.migration.BlobMigrationMBean;
import org.apache.jackrabbit.oak.plugins.blob.migration.BlobMigrator;
import org.apache.jackrabbit.oak.spi.blob.BlobStore;
import org.apache.jackrabbit.oak.spi.blob.split.SplitBlobStore;
import org.apache.jackrabbit.oak.spi.state.NodeStore;
import org.apache.jackrabbit.oak.spi.whiteboard.Registration;
import org.apache.jackrabbit.oak.spi.whiteboard.WhiteboardUtils;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public class BlobMigration
extends AnnotatedStandardMBean
implements BlobMigrationMBean {
    public static final String OP_NAME = "Blob migration";
    private static final Logger log;
    private ManagementOperation<String> migrationOp = ManagementOperation.done("Blob migration", "");
    private static final CompositeType TYPE;
    @Reference(target="(service.pid=org.apache.jackrabbit.oak.spi.blob.split.SplitBlobStore)")
    private BlobStore splitBlobStore;
    @Reference
    private NodeStore nodeStore;
    private Executor executor = Executors.newSingleThreadExecutor();
    private BlobMigrator migrator;
    private Registration mbeanReg;

    public BlobMigration() {
        super(BlobMigrationMBean.class);
    }

    @Activate
    private void activate(BundleContext ctx) {
        OsgiWhiteboard wb = new OsgiWhiteboard(ctx);
        this.migrator = new BlobMigrator((SplitBlobStore)this.splitBlobStore, this.nodeStore);
        this.mbeanReg = WhiteboardUtils.registerMBean(wb, BlobMigrationMBean.class, this, "BlobMigration", OP_NAME);
    }

    @Deactivate
    private void deactivate() throws InterruptedException {
        if (this.migrator != null) {
            this.migrator.stop();
            this.migrator = null;
        }
        if (this.mbeanReg != null) {
            this.mbeanReg.unregister();
            this.mbeanReg = null;
        }
    }

    @Override
    @Nonnull
    public String startBlobMigration(final boolean resume) {
        if (this.migrationOp.isDone()) {
            this.migrationOp = ManagementOperation.newManagementOperation(OP_NAME, new Callable<String>(){

                @Override
                public String call() throws Exception {
                    long t0 = System.nanoTime();
                    boolean finished = resume ? BlobMigration.this.migrator.migrate() : BlobMigration.this.migrator.start();
                    String duration = ManagementOperation.Status.formatTime(System.nanoTime() - t0);
                    if (finished) {
                        return "All blobs migrated in " + duration;
                    }
                    return "Migration stopped manually after " + duration;
                }
            });
            this.executor.execute(this.migrationOp);
            return "Migration started";
        }
        return "Migration is already in progress";
    }

    @Override
    @Nonnull
    public String stopBlobMigration() {
        this.migrator.stop();
        return "Migration will be stopped";
    }

    @Override
    @Nonnull
    public CompositeData getBlobMigrationStatus() throws OpenDataException {
        HashMap<String, Object> status = new HashMap<String, Object>();
        status.put("isRunning", this.migrationOp.getStatus().getCode() == RepositoryManagementMBean.StatusCode.RUNNING);
        status.put("migratedNodes", this.migrator.getTotalMigratedNodes());
        status.put("lastProcessedPath", this.migrator.getLastProcessedPath());
        status.put("operationStatus", this.migrationOp.getStatus().toCompositeData());
        return new CompositeDataSupport(TYPE, status);
    }

    static {
        CompositeType type;
        log = LoggerFactory.getLogger(BlobMigrator.class);
        try {
            type = new CompositeType("BlobMigrationStatus", "Status of the blob migraiton", new String[]{"isRunning", "migratedNodes", "lastProcessedPath", "operationStatus"}, new String[]{"Migration in progress", "Total number of migrated nodes", "Last processed path", "Status of the operation"}, new OpenType[]{SimpleType.BOOLEAN, SimpleType.INTEGER, SimpleType.STRING, ManagementOperation.Status.ITEM_TYPES});
        }
        catch (OpenDataException e) {
            type = null;
            log.error("Can't create a CompositeType", (Throwable)e);
        }
        TYPE = type;
    }

    protected void bindSplitBlobStore(BlobStore blobStore) {
        this.splitBlobStore = blobStore;
    }

    protected void unbindSplitBlobStore(BlobStore blobStore) {
        if (this.splitBlobStore == blobStore) {
            this.splitBlobStore = null;
        }
    }

    protected void bindNodeStore(NodeStore nodeStore) {
        this.nodeStore = nodeStore;
    }

    protected void unbindNodeStore(NodeStore nodeStore) {
        if (this.nodeStore == nodeStore) {
            this.nodeStore = null;
        }
    }
}

