/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.commons;

import javax.annotation.Nonnull;
import org.apache.jackrabbit.util.Text;

public final class QueryUtils {
    private QueryUtils() {
    }

    @Nonnull
    public static String escapeNodeName(@Nonnull String string) {
        int j;
        StringBuilder result = new StringBuilder();
        int k = 0;
        do {
            if ((j = string.indexOf(37, k)) < 0) {
                result.append(Text.escapeIllegalJcrChars(string.substring(k)));
            } else if (j > 0 && string.charAt(j - 1) == '\\') {
                result.append(Text.escapeIllegalJcrChars(string.substring(k, j) + '%'));
            } else {
                result.append(Text.escapeIllegalJcrChars(string.substring(k, j))).append('%');
            }
            k = j + 1;
        } while (j >= 0);
        return result.toString();
    }

    @Nonnull
    public static String escapeForQuery(@Nonnull String value) {
        StringBuilder ret = new StringBuilder();
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c == '\\') {
                ret.append("\\\\");
                continue;
            }
            if (c == '\'') {
                ret.append("''");
                continue;
            }
            ret.append(c);
        }
        return ret.toString();
    }
}

