/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.observation;

import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.plugins.observation.FilteringAwareObserver;
import org.apache.jackrabbit.oak.plugins.observation.FilteringObserver;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.commit.Observer;
import org.apache.jackrabbit.oak.spi.state.NodeState;

public class FilteringDispatcher
implements Observer {
    private final FilteringAwareObserver observer;
    private NodeState before;

    public FilteringDispatcher(FilteringAwareObserver observer) {
        this.observer = (FilteringAwareObserver)Preconditions.checkNotNull((Object)observer);
    }

    @Override
    public void contentChanged(@Nonnull NodeState root, @Nonnull CommitInfo info) {
        if (this.before != null && info != FilteringObserver.NOOP_CHANGE) {
            this.observer.contentChanged(this.before, root, info);
        }
        this.before = root;
    }
}

