/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.whiteboard;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.jackrabbit.oak.spi.whiteboard.Registration;
import org.apache.jackrabbit.oak.spi.whiteboard.Tracker;
import org.apache.jackrabbit.oak.spi.whiteboard.Whiteboard;

public class DefaultWhiteboard
implements Whiteboard {
    private final Map<Class<?>, Set<Object>> registry = Maps.newHashMap();

    private synchronized <T> void registered(Class<T> type, T service) {
        Set services = this.registry.get(type);
        if (services == null) {
            services = Sets.newIdentityHashSet();
            this.registry.put(type, services);
        }
        services.add(service);
    }

    private synchronized <T> void unregistered(Class<T> type, T service) {
        Set<Object> services = this.registry.get(type);
        if (services != null) {
            services.remove(service);
        }
    }

    private synchronized <T> List<T> lookup(Class<T> type) {
        Set<Object> services = this.registry.get(type);
        if (services != null) {
            return Lists.newArrayList(services);
        }
        return Collections.emptyList();
    }

    @Override
    public <T> Registration register(final Class<T> type, final T service, Map<?, ?> properties) {
        Preconditions.checkNotNull(type);
        Preconditions.checkNotNull(service);
        Preconditions.checkArgument((boolean)type.isInstance(service));
        this.registered(type, service);
        return new Registration(){

            @Override
            public void unregister() {
                DefaultWhiteboard.this.unregistered(type, service);
            }
        };
    }

    @Override
    public <T> Tracker<T> track(final Class<T> type) {
        Preconditions.checkNotNull(type);
        return new Tracker<T>(){

            @Override
            public List<T> getServices() {
                return DefaultWhiteboard.this.lookup(type);
            }

            @Override
            public void stop() {
            }
        };
    }
}

