/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.user.query;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GroupPredicate
implements Predicate<Authorizable> {
    static final Logger log = LoggerFactory.getLogger(GroupPredicate.class);
    private final Iterator<Authorizable> membersIterator;
    private final Set<String> memberIds = new HashSet<String>();

    GroupPredicate(UserManager userManager, String groupId, boolean declaredMembersOnly) throws RepositoryException {
        Group group;
        Authorizable authorizable = userManager.getAuthorizable(groupId);
        Group group2 = group = authorizable == null || !authorizable.isGroup() ? null : (Group)authorizable;
        this.membersIterator = group != null ? (declaredMembersOnly ? group.getDeclaredMembers() : group.getMembers()) : Iterators.emptyIterator();
    }

    public boolean apply(@Nullable Authorizable authorizable) {
        if (authorizable != null) {
            try {
                String id = authorizable.getID();
                if (this.memberIds.contains(id)) {
                    return true;
                }
                while (this.membersIterator.hasNext()) {
                    String memberId = this.saveGetId(this.membersIterator.next());
                    if (memberId == null) continue;
                    this.memberIds.add(memberId);
                    if (!memberId.equals(id)) continue;
                    return true;
                }
            }
            catch (RepositoryException e) {
                log.debug("Cannot determine group membership for {}", (Object)authorizable, (Object)e);
            }
        }
        return false;
    }

    @CheckForNull
    private String saveGetId(@Nonnull Authorizable authorizable) {
        try {
            return authorizable.getID();
        }
        catch (RepositoryException e) {
            log.debug("Error while retrieving ID for authorizable {}", (Object)authorizable, (Object)e);
            return null;
        }
    }
}

