/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.user;

import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.security.Principal;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.ConstraintViolationException;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.commons.iterator.RangeIteratorAdapter;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.security.user.AbstractGroupPrincipal;
import org.apache.jackrabbit.oak.security.user.AuthorizableBaseProvider;
import org.apache.jackrabbit.oak.security.user.AuthorizableImpl;
import org.apache.jackrabbit.oak.security.user.AuthorizableIterator;
import org.apache.jackrabbit.oak.security.user.MembershipProvider;
import org.apache.jackrabbit.oak.security.user.UserManagerImpl;
import org.apache.jackrabbit.oak.spi.security.user.AuthorizableType;
import org.apache.jackrabbit.oak.spi.security.user.util.UserUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GroupImpl
extends AuthorizableImpl
implements Group {
    private static final Logger log = LoggerFactory.getLogger(GroupImpl.class);

    GroupImpl(String id, Tree tree, UserManagerImpl userManager) throws RepositoryException {
        super(id, tree, userManager);
    }

    @Override
    void checkValidTree(Tree tree) throws RepositoryException {
        if (tree == null || !UserUtil.isType(tree, AuthorizableType.GROUP)) {
            throw new IllegalArgumentException("Invalid group node: node type rep:Group expected.");
        }
    }

    @Override
    public boolean isGroup() {
        return true;
    }

    @Override
    public Principal getPrincipal() throws RepositoryException {
        return new GroupPrincipal(this.getPrincipalName(), this.getTree());
    }

    @Override
    public Iterator<Authorizable> getDeclaredMembers() throws RepositoryException {
        return this.getMembers(false);
    }

    @Override
    public Iterator<Authorizable> getMembers() throws RepositoryException {
        return this.getMembers(true);
    }

    @Override
    public boolean isDeclaredMember(Authorizable authorizable) throws RepositoryException {
        return this.isMember(authorizable, false);
    }

    @Override
    public boolean isMember(Authorizable authorizable) throws RepositoryException {
        return this.isMember(authorizable, true);
    }

    @Override
    public boolean addMember(Authorizable authorizable) throws RepositoryException {
        if (!GroupImpl.isValidAuthorizableImpl(authorizable)) {
            log.warn("Invalid Authorizable: {}", (Object)authorizable);
            return false;
        }
        AuthorizableImpl authorizableImpl = (AuthorizableImpl)authorizable;
        if (this.isEveryone() || authorizableImpl.isEveryone()) {
            return false;
        }
        String memberID = authorizable.getID();
        if (authorizableImpl.isGroup()) {
            if (this.getID().equals(memberID)) {
                String msg = "Attempt to add a group as member of itself (" + this.getID() + ").";
                log.debug(msg);
                return false;
            }
            if (this.isCyclicMembership(authorizableImpl)) {
                log.warn("Attempt to create circular group membership.");
                return false;
            }
        }
        return this.getMembershipProvider().addMember(this.getTree(), authorizableImpl.getTree());
    }

    @Override
    public Set<String> addMembers(String ... memberIds) throws RepositoryException {
        return this.updateMembers(false, memberIds);
    }

    private boolean isCyclicMembership(AuthorizableImpl newMember) {
        if (newMember.isGroup()) {
            MembershipProvider mProvider = this.getMembershipProvider();
            String contentId = mProvider.getContentID(this.getTree());
            if (mProvider.isMember(newMember.getTree(), contentId, true)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean removeMember(Authorizable authorizable) throws RepositoryException {
        if (!GroupImpl.isValidAuthorizableImpl(authorizable)) {
            log.warn("Invalid Authorizable: {}", (Object)authorizable);
            return false;
        }
        if (this.isEveryone()) {
            return false;
        }
        Tree memberTree = ((AuthorizableImpl)authorizable).getTree();
        return this.getMembershipProvider().removeMember(this.getTree(), memberTree);
    }

    @Override
    public Set<String> removeMembers(String ... memberIds) throws RepositoryException {
        return this.updateMembers(true, memberIds);
    }

    private Iterator<Authorizable> getMembers(boolean includeInherited) throws RepositoryException {
        UserManagerImpl userMgr = this.getUserManager();
        if (this.isEveryone()) {
            String propName = this.getUserManager().getNamePathMapper().getJcrName("rep:principalName");
            return Iterators.filter(userMgr.findAuthorizables(propName, null, 3), (Predicate)new Predicate<Authorizable>(){

                public boolean apply(@Nullable Authorizable authorizable) {
                    if (authorizable == null) {
                        return false;
                    }
                    if (authorizable.isGroup()) {
                        try {
                            return !((GroupImpl)authorizable).isEveryone();
                        }
                        catch (RepositoryException e) {
                            log.warn("Unable to evaluate if authorizable is the 'everyone' group.", (Throwable)e);
                        }
                    }
                    return true;
                }
            });
        }
        Iterator<String> oakPaths = this.getMembershipProvider().getMembers(this.getTree(), AuthorizableType.AUTHORIZABLE, includeInherited);
        if (oakPaths.hasNext()) {
            AuthorizableIterator iterator = AuthorizableIterator.create(oakPaths, userMgr, AuthorizableType.AUTHORIZABLE);
            return new RangeIteratorAdapter(iterator, iterator.getSize());
        }
        return RangeIteratorAdapter.EMPTY;
    }

    private boolean isMember(Authorizable authorizable, boolean includeInherited) throws RepositoryException {
        if (!GroupImpl.isValidAuthorizableImpl(authorizable)) {
            return false;
        }
        if (this.getID().equals(authorizable.getID())) {
            return false;
        }
        if (this.isEveryone()) {
            return true;
        }
        Tree authorizableTree = ((AuthorizableImpl)authorizable).getTree();
        MembershipProvider mgr = this.getUserManager().getMembershipProvider();
        return mgr.isMember(this.getTree(), authorizableTree, includeInherited);
    }

    private final Set<String> updateMembers(boolean isRemove, String ... memberIds) throws RepositoryException {
        LinkedHashSet idSet = Sets.newLinkedHashSet((Iterable)Lists.newArrayList((Object[])memberIds));
        int importBehavior = UserUtil.getImportBehavior(this.getUserManager().getConfig());
        Iterator idIterator = idSet.iterator();
        while (idIterator.hasNext()) {
            Authorizable member;
            String memberId = (String)idIterator.next();
            if (Strings.isNullOrEmpty((String)memberId)) {
                throw new ConstraintViolationException("MemberId must not be null or empty.");
            }
            if (this.getID().equals(memberId)) {
                String msg = "Attempt to add or remove a group as member of itself (" + this.getID() + ").";
                log.debug(msg);
                continue;
            }
            if (2 != importBehavior && (member = this.getUserManager().getAuthorizable(memberId)) == null) {
                if (3 == importBehavior) {
                    throw new ConstraintViolationException("Attempt to add or remove a non-existing member " + memberId);
                }
                if (1 == importBehavior) {
                    String msg = "Attempt to add or remove non-existing member '" + this.getID() + "' with ImportBehavior = IGNORE.";
                    log.debug(msg);
                    continue;
                }
            }
            String contentId = AuthorizableBaseProvider.getContentID(memberId);
            boolean success = isRemove ? this.getMembershipProvider().removeMember(this.getTree(), contentId) : this.getMembershipProvider().addMember(this.getTree(), contentId);
            if (!success) continue;
            idIterator.remove();
        }
        return idSet;
    }

    private final class GroupPrincipal
    extends AbstractGroupPrincipal {
        private GroupPrincipal(String principalName, Tree groupTree) {
            super(principalName, groupTree, GroupImpl.this.getUserManager().getNamePathMapper());
        }

        @Override
        UserManager getUserManager() {
            return GroupImpl.this.getUserManager();
        }

        @Override
        boolean isEveryone() throws RepositoryException {
            return GroupImpl.this.isEveryone();
        }

        @Override
        boolean isMember(@Nonnull Authorizable authorizable) throws RepositoryException {
            return GroupImpl.this.isMember(authorizable);
        }

        @Override
        @Nonnull
        Iterator<Authorizable> getMembers() throws RepositoryException {
            return GroupImpl.this.getMembers();
        }
    }
}

