/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.query.fulltext;

import org.apache.jackrabbit.oak.query.fulltext.FullTextExpression;
import org.apache.jackrabbit.oak.query.fulltext.FullTextVisitor;
import org.apache.jackrabbit.oak.query.fulltext.LikePattern;

public class FullTextTerm
extends FullTextExpression {
    private final boolean not;
    private final String propertyName;
    private final String text;
    private final String filteredText;
    private final String boost;
    private final LikePattern like;

    public FullTextTerm(String propertyName, FullTextTerm copy) {
        this.propertyName = propertyName;
        this.not = copy.not;
        this.text = copy.text;
        this.filteredText = copy.filteredText;
        this.boost = copy.boost;
        this.like = copy.like;
    }

    public FullTextTerm(String propertyName, String text, boolean not, boolean escaped, String boost) {
        this.propertyName = propertyName;
        this.text = text;
        this.not = not;
        this.boost = boost;
        boolean pattern = false;
        if (escaped) {
            this.filteredText = text;
        } else {
            StringBuilder buff = new StringBuilder();
            for (int i = 0; i < text.length(); ++i) {
                char c = text.charAt(i);
                if (c == '*') {
                    buff.append('%');
                    pattern = true;
                    continue;
                }
                if (c == '?') {
                    buff.append('_');
                    pattern = true;
                    continue;
                }
                if (c == '_') {
                    buff.append("\\_");
                    pattern = true;
                    continue;
                }
                if (!FullTextTerm.isFullTextCharacter(c) && " +-:&/.".indexOf(c) < 0) continue;
                buff.append(c);
            }
            this.filteredText = buff.toString().toLowerCase();
        }
        this.like = pattern ? new LikePattern("%" + this.filteredText + "%") : null;
    }

    public static boolean isFullTextCharacter(char c) {
        switch (Character.getType(c)) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return true;
            }
            case 9: 
            case 10: 
            case 11: {
                return true;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                return true;
            }
            case 15: 
            case 16: {
                return false;
            }
            case 0: 
            case 18: 
            case 19: {
                return true;
            }
            case 6: 
            case 7: 
            case 8: {
                return false;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 29: 
            case 30: {
                return false;
            }
            case 12: 
            case 13: 
            case 14: {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean evaluate(String value) {
        value = value.toLowerCase();
        if (this.like != null) {
            return this.like.matches(value);
        }
        if (this.not) {
            return value.indexOf(this.filteredText) < 0;
        }
        return value.indexOf(this.filteredText) >= 0;
    }

    @Override
    public FullTextExpression simplify() {
        return this;
    }

    @Override
    public String toString() {
        StringBuilder buff = new StringBuilder();
        if (this.not) {
            buff.append('-');
        }
        if (this.propertyName != null && !"*".equals(this.propertyName)) {
            buff.append(this.propertyName).append(':');
        }
        buff.append('\"');
        for (int i = 0; i < this.text.length(); ++i) {
            char c = this.text.charAt(i);
            if (c == '\\') {
                buff.append(c);
            } else if (c == '\"') {
                buff.append('\\');
            }
            buff.append(c);
        }
        buff.append('\"');
        if (this.boost != null) {
            buff.append('^').append(this.boost);
        }
        return buff.toString();
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public String getBoost() {
        return this.boost;
    }

    @Override
    public boolean isNot() {
        return this.not;
    }

    public String getText() {
        return this.text;
    }

    @Override
    public int getPrecedence() {
        return 3;
    }

    @Override
    public boolean accept(FullTextVisitor v) {
        return v.visit(this);
    }
}

