/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.query.fulltext;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.jackrabbit.oak.query.fulltext.FullTextExpression;
import org.apache.jackrabbit.oak.query.fulltext.FullTextOr;
import org.apache.jackrabbit.oak.query.fulltext.FullTextVisitor;

public class FullTextAnd
extends FullTextExpression {
    public final List<FullTextExpression> list;

    public FullTextAnd(List<FullTextExpression> list) {
        this.list = list;
    }

    @Override
    public boolean evaluate(String value) {
        for (FullTextExpression e : this.list) {
            if (e.evaluate(value)) continue;
            return false;
        }
        return true;
    }

    @Override
    public FullTextExpression simplify() {
        Set<FullTextExpression> set = FullTextOr.getSortedAndUniqueSet(this.list);
        if (set.size() == 1) {
            return set.iterator().next();
        }
        ArrayList<FullTextExpression> l = new ArrayList<FullTextExpression>(set.size());
        l.addAll(set);
        return new FullTextAnd(l);
    }

    @Override
    public String toString() {
        StringBuilder buff = new StringBuilder();
        int i = 0;
        for (FullTextExpression e : this.list) {
            if (i++ > 0) {
                buff.append(' ');
            }
            if (e.getPrecedence() < this.getPrecedence()) {
                buff.append('(');
            }
            buff.append(e.toString());
            if (e.getPrecedence() >= this.getPrecedence()) continue;
            buff.append(')');
        }
        return buff.toString();
    }

    @Override
    public int getPrecedence() {
        return 2;
    }

    @Override
    public boolean accept(FullTextVisitor v) {
        return v.visit(this);
    }
}

