/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.tree.impl;

import com.google.common.base.Preconditions;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.jackrabbit.oak.plugins.tree.impl.AbstractMutableTree;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;

public final class NodeBuilderTree
extends AbstractMutableTree {
    private final NodeBuilderTree parent;
    private final String name;
    private final NodeBuilder nodeBuilder;

    public NodeBuilderTree(@Nonnull String name, @Nonnull NodeBuilder nodeBuilder) {
        this(null, nodeBuilder, name);
    }

    protected NodeBuilderTree(@Nullable NodeBuilderTree parent, @Nonnull NodeBuilder nodeBuilder, @Nonnull String name) {
        this.parent = parent;
        this.name = name;
        this.nodeBuilder = nodeBuilder;
    }

    @Override
    @CheckForNull
    protected AbstractMutableTree getParentOrNull() {
        return this.parent;
    }

    @Override
    @Nonnull
    protected NodeBuilder getNodeBuilder() {
        return this.nodeBuilder;
    }

    @Override
    @Nonnull
    public String getName() {
        return this.name;
    }

    @Override
    @Nonnull
    protected NodeBuilderTree createChild(@Nonnull String name) throws IllegalArgumentException {
        return new NodeBuilderTree(this, this.nodeBuilder.getChildNode((String)Preconditions.checkNotNull((Object)name)), name);
    }
}

