/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.tree.impl;

import com.google.common.collect.Sets;
import java.util.Iterator;
import java.util.LinkedHashSet;
import javax.annotation.CheckForNull;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;

public final class ChildOrderDiff {
    private ChildOrderDiff() {
    }

    @CheckForNull
    public static String firstReordered(PropertyState before, PropertyState after) {
        LinkedHashSet afterNames = Sets.newLinkedHashSet(after.getValue(Type.NAMES));
        LinkedHashSet beforeNames = Sets.newLinkedHashSet(before.getValue(Type.NAMES));
        Iterator a = afterNames.iterator();
        Iterator b = beforeNames.iterator();
        while (a.hasNext() && b.hasNext()) {
            String aName = (String)a.next();
            String bName = (String)b.next();
            while (!aName.equals(bName)) {
                if (!beforeNames.contains(aName)) {
                    if (a.hasNext()) {
                        aName = (String)a.next();
                        continue;
                    }
                    return null;
                }
                if (!afterNames.contains(bName)) {
                    if (b.hasNext()) {
                        bName = (String)b.next();
                        continue;
                    }
                    return null;
                }
                return aName;
            }
        }
        return null;
    }
}

