/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.segment.file;

import javax.annotation.Nonnull;
import javax.management.openmbean.CompositeData;
import org.apache.jackrabbit.api.stats.TimeSeries;
import org.apache.jackrabbit.oak.commons.IOUtils;
import org.apache.jackrabbit.oak.plugins.segment.file.FileStore;
import org.apache.jackrabbit.oak.plugins.segment.file.FileStoreMonitor;
import org.apache.jackrabbit.oak.plugins.segment.file.FileStoreStatsMBean;
import org.apache.jackrabbit.oak.stats.CounterStats;
import org.apache.jackrabbit.oak.stats.MeterStats;
import org.apache.jackrabbit.oak.stats.StatisticsProvider;
import org.apache.jackrabbit.oak.stats.StatsOptions;
import org.apache.jackrabbit.stats.TimeSeriesStatsUtil;

public class FileStoreStats
implements FileStoreStatsMBean,
FileStoreMonitor {
    public static final String SEGMENT_REPO_SIZE = "SEGMENT_REPO_SIZE";
    public static final String SEGMENT_WRITES = "SEGMENT_WRITES";
    private final StatisticsProvider statisticsProvider;
    private final FileStore store;
    private final MeterStats writeStats;
    private final CounterStats repoSize;

    public FileStoreStats(StatisticsProvider statisticsProvider, FileStore store, long initialSize) {
        this.statisticsProvider = statisticsProvider;
        this.store = store;
        this.writeStats = statisticsProvider.getMeter(SEGMENT_WRITES, StatsOptions.DEFAULT);
        this.repoSize = statisticsProvider.getCounterStats(SEGMENT_REPO_SIZE, StatsOptions.DEFAULT);
        this.repoSize.inc(initialSize);
    }

    @Override
    public void written(long delta) {
        this.writeStats.mark(delta);
        this.repoSize.inc(delta);
    }

    @Override
    public void reclaimed(long size) {
        this.repoSize.dec(size);
    }

    @Override
    public long getApproximateSize() {
        return this.repoSize.getCount();
    }

    @Override
    public int getTarFileCount() {
        return this.store.readerCount() + 1;
    }

    @Override
    @Nonnull
    public CompositeData getWriteStats() {
        return TimeSeriesStatsUtil.asCompositeData(this.getTimeSeries(SEGMENT_WRITES), SEGMENT_WRITES);
    }

    @Override
    @Nonnull
    public CompositeData getRepositorySize() {
        return TimeSeriesStatsUtil.asCompositeData(this.getTimeSeries(SEGMENT_REPO_SIZE), SEGMENT_REPO_SIZE);
    }

    @Override
    public String fileStoreInfoAsString() {
        return String.format("Segment store size : %s%nNumber of tar files : %d", IOUtils.humanReadableByteCount(this.getApproximateSize()), this.getTarFileCount());
    }

    private TimeSeries getTimeSeries(String name) {
        return this.statisticsProvider.getStats().getTimeSeries(name, true);
    }
}

