/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.observation.filter;

import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.plugins.observation.filter.EventFilter;
import org.apache.jackrabbit.oak.plugins.observation.filter.Filters;
import org.apache.jackrabbit.oak.spi.state.NodeState;

public class GlobbingPathFilter
implements EventFilter {
    public static final String STAR = "*";
    public static final String STAR_STAR = "**";
    private final ImmutableList<String> pattern;

    private GlobbingPathFilter(@Nonnull Iterable<String> pattern) {
        this.pattern = ImmutableList.copyOf((Iterable)((Iterable)Preconditions.checkNotNull(pattern)));
    }

    public GlobbingPathFilter(@Nonnull String pattern) {
        this(PathUtils.elements(pattern));
    }

    @Override
    public boolean includeAdd(PropertyState after) {
        return this.includeItem(after.getName());
    }

    @Override
    public boolean includeChange(PropertyState before, PropertyState after) {
        return this.includeItem(after.getName());
    }

    @Override
    public boolean includeDelete(PropertyState before) {
        return this.includeItem(before.getName());
    }

    @Override
    public boolean includeAdd(String name, NodeState after) {
        return this.includeItem(name);
    }

    @Override
    public boolean includeDelete(String name, NodeState before) {
        return this.includeItem(name);
    }

    @Override
    public boolean includeMove(String sourcePath, String name, NodeState moved) {
        return this.includeItem(name);
    }

    @Override
    public boolean includeReorder(String destName, String name, NodeState reordered) {
        return this.includeItem(name);
    }

    @Override
    public EventFilter create(String name, NodeState before, NodeState after) {
        if (this.pattern.isEmpty()) {
            return null;
        }
        String head = (String)this.pattern.get(0);
        if (this.pattern.size() == 1 && !STAR_STAR.equals(head)) {
            return null;
        }
        if (STAR.equals(head) || head.equals(name)) {
            return new GlobbingPathFilter((Iterable<String>)this.pattern.subList(1, this.pattern.size()));
        }
        if (STAR_STAR.equals(head)) {
            if (this.pattern.size() >= 2 && ((String)this.pattern.get(1)).equals(name)) {
                return Filters.any(new GlobbingPathFilter((Iterable<String>)this.pattern.subList(2, this.pattern.size())), new GlobbingPathFilter((Iterable<String>)this.pattern));
            }
            return new GlobbingPathFilter((Iterable<String>)this.pattern);
        }
        return null;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("path", (Object)Joiner.on((char)'/').join(this.pattern)).toString();
    }

    private boolean includeItem(String name) {
        if (!this.pattern.isEmpty() && this.pattern.size() <= 2) {
            boolean headMatches;
            String head = (String)this.pattern.get(0);
            boolean bl = headMatches = STAR.equals(head) || STAR_STAR.equals(head) || head.equals(name);
            return this.pattern.size() == 1 ? headMatches : headMatches && STAR_STAR.equals(this.pattern.get(1));
        }
        return false;
    }
}

