/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.blob.datastore;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Property;
import org.apache.jackrabbit.oak.commons.PropertiesUtil;
import org.apache.jackrabbit.oak.plugins.blob.datastore.DataStoreTextWriter;
import org.apache.jackrabbit.oak.plugins.index.fulltext.PreExtractedTextProvider;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

@Component(policy=ConfigurationPolicy.REQUIRE, metatype=true, label="Apache Jackrabbit Oak DataStore PreExtractedTextProvider", description="Configures a PreExtractedTextProvider based on extracted text stored on FileSystem")
public class DataStoreTextProviderService {
    @Property(label="Path", description="Local file system path where extracted text is stored in files.")
    private static final String PROP_DIR = "dir";
    private DataStoreTextWriter textWriter;
    private ServiceRegistration reg;

    @Activate
    private void activate(BundleContext context, Map<String, ?> config) throws IOException {
        String dirPath = PropertiesUtil.toString(config.get(PROP_DIR), null);
        Preconditions.checkNotNull((Object)dirPath, (String)"Directory path not configured via '%s", (Object[])new Object[]{PROP_DIR});
        File dir = new File(dirPath);
        Preconditions.checkArgument((boolean)dir.exists(), (String)"Directory %s does not exist", (Object[])new Object[]{dir.getAbsolutePath()});
        this.textWriter = new DataStoreTextWriter(dir, true);
        this.reg = context.registerService(PreExtractedTextProvider.class.getName(), (Object)this.textWriter, null);
    }

    @Deactivate
    private void deactivate() throws IOException {
        this.textWriter.close();
        if (this.reg != null) {
            this.reg.unregister();
        }
    }
}

