/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.state;

import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.spi.state.AbstractRebaseDiff;
import org.apache.jackrabbit.oak.spi.state.ConflictType;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;

public class ConflictAnnotatingRebaseDiff
extends AbstractRebaseDiff {
    public static final String CONFLICT = ":conflict";

    public ConflictAnnotatingRebaseDiff(NodeBuilder builder) {
        super(builder);
    }

    @Override
    protected ConflictAnnotatingRebaseDiff createDiff(NodeBuilder builder, String name) {
        return new ConflictAnnotatingRebaseDiff(builder.child(name));
    }

    @Override
    protected void addExistingProperty(NodeBuilder builder, PropertyState before, PropertyState after) {
        ConflictAnnotatingRebaseDiff.conflictMarker(builder, ConflictType.ADD_EXISTING_PROPERTY).setProperty(after);
    }

    @Override
    protected void changeDeletedProperty(NodeBuilder builder, PropertyState after) {
        ConflictAnnotatingRebaseDiff.conflictMarker(builder, ConflictType.CHANGE_DELETED_PROPERTY).setProperty(after);
    }

    @Override
    protected void changeChangedProperty(NodeBuilder builder, PropertyState before, PropertyState after) {
        ConflictAnnotatingRebaseDiff.conflictMarker(builder, ConflictType.CHANGE_CHANGED_PROPERTY).setProperty(after);
    }

    @Override
    protected void deleteDeletedProperty(NodeBuilder builder, PropertyState before) {
        ConflictAnnotatingRebaseDiff.conflictMarker(builder, ConflictType.DELETE_DELETED_PROPERTY).setProperty(before);
    }

    @Override
    protected void deleteChangedProperty(NodeBuilder builder, PropertyState before) {
        ConflictAnnotatingRebaseDiff.conflictMarker(builder, ConflictType.DELETE_CHANGED_PROPERTY).setProperty(before);
    }

    @Override
    protected void addExistingNode(NodeBuilder builder, String name, NodeState before, NodeState after) {
        ConflictAnnotatingRebaseDiff.conflictMarker(builder, ConflictType.ADD_EXISTING_NODE).setChildNode(name, after);
    }

    @Override
    protected void changeDeletedNode(NodeBuilder builder, String name, NodeState after) {
        ConflictAnnotatingRebaseDiff.conflictMarker(builder, ConflictType.CHANGE_DELETED_NODE).setChildNode(name, after);
    }

    @Override
    protected void deleteDeletedNode(NodeBuilder builder, String name, NodeState before) {
        ConflictAnnotatingRebaseDiff.conflictMarker(builder, ConflictType.DELETE_DELETED_NODE).setChildNode(name, before);
    }

    @Override
    protected void deleteChangedNode(NodeBuilder builder, String name, NodeState before) {
        ConflictAnnotatingRebaseDiff.conflictMarker(builder, ConflictType.DELETE_CHANGED_NODE).setChildNode(name, before);
    }

    private static NodeBuilder conflictMarker(NodeBuilder builder, ConflictType ct) {
        return builder.child(CONFLICT).child(ct.getName());
    }
}

