/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.authentication.token;

import com.google.common.collect.ImmutableList;
import java.security.Principal;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.security.authentication.token.TokenProviderImpl;
import org.apache.jackrabbit.oak.security.authentication.token.TokenValidatorProvider;
import org.apache.jackrabbit.oak.spi.commit.MoveTracker;
import org.apache.jackrabbit.oak.spi.commit.ValidatorProvider;
import org.apache.jackrabbit.oak.spi.security.ConfigurationBase;
import org.apache.jackrabbit.oak.spi.security.ConfigurationParameters;
import org.apache.jackrabbit.oak.spi.security.SecurityConfiguration;
import org.apache.jackrabbit.oak.spi.security.SecurityProvider;
import org.apache.jackrabbit.oak.spi.security.authentication.token.TokenConfiguration;
import org.apache.jackrabbit.oak.spi.security.authentication.token.TokenProvider;
import org.apache.jackrabbit.oak.spi.security.user.UserConfiguration;

@Component(metatype=true, label="Apache Jackrabbit Oak TokenConfiguration")
@Service(value={TokenConfiguration.class, SecurityConfiguration.class})
@Properties(value={@Property(name="tokenExpiration", label="Token Expiration", description="Expiration time of login tokens in ms."), @Property(name="tokenLength", label="Token Length", description="Length of the generated token."), @Property(name="tokenRefresh", label="Token Refresh", description="Enable/disable refresh of login tokens (i.e. resetting the expiration time).", boolValue={true}), @Property(name="passwordHashAlgorithm", label="Hash Algorithm", description="Name of the algorithm to hash the token.", value={"SHA-256"}), @Property(name="passwordHashIterations", label="Hash Iterations", description="Number of iterations used to hash the token.", intValue={1000}), @Property(name="passwordSaltSize", label="Hash Salt Size", description="Size of the salt used to generate the hash.", intValue={8})})
public class TokenConfigurationImpl
extends ConfigurationBase
implements TokenConfiguration {
    public TokenConfigurationImpl() {
    }

    public TokenConfigurationImpl(SecurityProvider securityProvider) {
        super(securityProvider, securityProvider.getParameters("org.apache.jackrabbit.oak.authentication.token"));
    }

    @Activate
    private void activate(Map<String, Object> properties) {
        this.setParameters(ConfigurationParameters.of(properties));
    }

    @Override
    @Nonnull
    public String getName() {
        return "org.apache.jackrabbit.oak.authentication.token";
    }

    @Override
    @Nonnull
    public List<? extends ValidatorProvider> getValidators(@Nonnull String workspaceName, @Nonnull Set<Principal> principals, @Nonnull MoveTracker moveTracker) {
        TokenValidatorProvider vp = new TokenValidatorProvider(this.getSecurityProvider().getParameters("org.apache.jackrabbit.oak.user"));
        return ImmutableList.of((Object)vp);
    }

    @Override
    @Nonnull
    public TokenProvider getTokenProvider(Root root) {
        UserConfiguration uc = this.getSecurityProvider().getConfiguration(UserConfiguration.class);
        return new TokenProviderImpl(root, this.getParameters(), uc);
    }
}

