/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.query.ast;

import org.apache.jackrabbit.oak.api.PropertyValue;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.query.fulltext.LikePattern;
import org.apache.jackrabbit.oak.spi.query.PropertyValues;

public enum Operator {
    EQUAL("="){

        @Override
        public boolean evaluate(PropertyValue p1, PropertyValue p2) {
            return PropertyValues.match(p1, p2);
        }
    }
    ,
    NOT_EQUAL("<>"){

        @Override
        public boolean evaluate(PropertyValue p1, PropertyValue p2) {
            return PropertyValues.notMatch(p1, p2);
        }
    }
    ,
    GREATER_THAN(">"){

        @Override
        public boolean evaluate(PropertyValue p1, PropertyValue p2) {
            return p1.compareTo(p2) > 0;
        }
    }
    ,
    GREATER_OR_EQUAL(">="){

        @Override
        public boolean evaluate(PropertyValue p1, PropertyValue p2) {
            return p1.compareTo(p2) >= 0;
        }
    }
    ,
    LESS_THAN("<"){

        @Override
        public boolean evaluate(PropertyValue p1, PropertyValue p2) {
            return p1.compareTo(p2) < 0;
        }
    }
    ,
    LESS_OR_EQUAL("<="){

        @Override
        public boolean evaluate(PropertyValue p1, PropertyValue p2) {
            return p1.compareTo(p2) <= 0;
        }
    }
    ,
    LIKE("like"){

        @Override
        public boolean evaluate(PropertyValue p1, PropertyValue p2) {
            LikePattern like = new LikePattern(p2.getValue(Type.STRING));
            for (String s : p1.getValue(Type.STRINGS)) {
                if (!like.matches(s)) continue;
                return true;
            }
            return false;
        }
    };

    private final String name;

    private Operator(String name) {
        this.name = name;
    }

    public abstract boolean evaluate(PropertyValue var1, PropertyValue var2);

    public String toString() {
        return this.name;
    }
}

