/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.query;

import org.apache.jackrabbit.oak.api.jmx.QueryEngineSettingsMBean;
import org.apache.jackrabbit.oak.commons.jmx.AnnotatedStandardMBean;

public class QueryEngineSettings
extends AnnotatedStandardMBean
implements QueryEngineSettingsMBean {
    public static final String SQL2_OPTIMISATION_FLAG = "oak.query.sql2optimisation";
    private static final int DEFAULT_QUERY_LIMIT_IN_MEMORY = Integer.getInteger("oak.queryLimitInMemory", Integer.MAX_VALUE);
    private static final int DEFAULT_QUERY_LIMIT_READS = Integer.getInteger("oak.queryLimitReads", Integer.MAX_VALUE);
    private static final boolean DEFAULT_FULL_TEXT_COMPARISON_WITHOUT_INDEX = Boolean.getBoolean("oak.queryFullTextComparisonWithoutIndex");
    private long limitInMemory = DEFAULT_QUERY_LIMIT_IN_MEMORY;
    private long limitReads = DEFAULT_QUERY_LIMIT_READS;
    private boolean fullTextComparisonWithoutIndex = DEFAULT_FULL_TEXT_COMPARISON_WITHOUT_INDEX;
    private boolean sql2Optimisation = Boolean.parseBoolean(System.getProperty("oak.query.sql2optimisation", "true"));

    public QueryEngineSettings() {
        super(QueryEngineSettingsMBean.class);
    }

    @Override
    public long getLimitInMemory() {
        return this.limitInMemory;
    }

    @Override
    public void setLimitInMemory(long limitInMemory) {
        this.limitInMemory = limitInMemory;
    }

    @Override
    public long getLimitReads() {
        return this.limitReads;
    }

    @Override
    public void setLimitReads(long limitReads) {
        this.limitReads = limitReads;
    }

    public void setFullTextComparisonWithoutIndex(boolean fullTextComparisonWithoutIndex) {
        this.fullTextComparisonWithoutIndex = fullTextComparisonWithoutIndex;
    }

    public boolean getFullTextComparisonWithoutIndex() {
        return this.fullTextComparisonWithoutIndex;
    }

    public boolean isSql2Optimisation() {
        return this.sql2Optimisation;
    }
}

