/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.persistentCache.async;

import java.util.Collections;
import java.util.Map;
import org.apache.jackrabbit.oak.plugins.document.persistentCache.PersistentCache;
import org.apache.jackrabbit.oak.plugins.document.persistentCache.async.CacheAction;
import org.apache.jackrabbit.oak.plugins.document.persistentCache.async.CacheWriteQueue;

class PutToCacheAction<K, V>
implements CacheAction<K, V> {
    private final PersistentCache cache;
    private final Map<K, V> map;
    private final CacheWriteQueue<K, V> owner;
    private final K key;
    private final V value;

    PutToCacheAction(CacheWriteQueue<K, V> cacheWriteQueue, K key, V value) {
        this.owner = cacheWriteQueue;
        this.key = key;
        this.value = value;
        this.cache = cacheWriteQueue.getCache();
        this.map = cacheWriteQueue.getMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() {
        try {
            if (this.map != null) {
                this.cache.switchGenerationIfNeeded();
                this.map.put(this.key, this.value);
            }
        }
        finally {
            this.decrement();
        }
    }

    @Override
    public void cancel() {
        this.decrement();
    }

    @Override
    public CacheWriteQueue<K, V> getOwner() {
        return this.owner;
    }

    @Override
    public Iterable<K> getAffectedKeys() {
        return Collections.singleton(this.key);
    }

    private void decrement() {
        this.owner.remove(this.key);
    }
}

