/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.persistentCache;

import java.nio.ByteBuffer;
import org.apache.jackrabbit.oak.cache.CacheValue;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStore;
import org.apache.jackrabbit.oak.plugins.document.DocumentStore;
import org.apache.jackrabbit.oak.plugins.document.persistentCache.CacheType;
import org.h2.mvstore.WriteBuffer;
import org.h2.mvstore.type.DataType;
import org.h2.mvstore.type.StringDataType;

public class ValueDataType
implements DataType {
    private final DocumentNodeStore docNodeStore;
    private final DocumentStore docStore;
    private final CacheType type;

    public ValueDataType(DocumentNodeStore docNodeStore, DocumentStore docStore, CacheType type) {
        this.docNodeStore = docNodeStore;
        this.docStore = docStore;
        this.type = type;
    }

    public int compare(Object a, Object b) {
        return 0;
    }

    public int getMemory(Object obj) {
        return ((CacheValue)obj).getMemory();
    }

    public void write(WriteBuffer buff, Object obj) {
        String s = this.type.valueToString(obj);
        StringDataType.INSTANCE.write(buff, (Object)s);
    }

    public Object read(ByteBuffer buff) {
        String s = StringDataType.INSTANCE.read(buff);
        return this.type.valueFromString(this.docNodeStore, this.docStore, s);
    }

    public void write(WriteBuffer buff, Object[] obj, int len, boolean key) {
        for (int i = 0; i < len; ++i) {
            this.write(buff, obj[i]);
        }
    }

    public void read(ByteBuffer buff, Object[] obj, int len, boolean key) {
        for (int i = 0; i < len; ++i) {
            obj[i] = this.read(buff);
        }
    }
}

