/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.commit;

import java.util.Calendar;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.spi.commit.PartialConflictHandler;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.util.ISO8601;

public class JcrLastModifiedConflictHandler
implements PartialConflictHandler {
    @Override
    public PartialConflictHandler.Resolution addExistingProperty(NodeBuilder parent, PropertyState ours, PropertyState theirs) {
        if (JcrLastModifiedConflictHandler.isLastModified(ours)) {
            JcrLastModifiedConflictHandler.merge(parent, ours, theirs);
            return PartialConflictHandler.Resolution.MERGED;
        }
        return null;
    }

    @Override
    public PartialConflictHandler.Resolution changeDeletedProperty(NodeBuilder parent, PropertyState ours) {
        return null;
    }

    @Override
    public PartialConflictHandler.Resolution changeChangedProperty(NodeBuilder parent, PropertyState ours, PropertyState theirs) {
        if (JcrLastModifiedConflictHandler.isLastModified(ours)) {
            JcrLastModifiedConflictHandler.merge(parent, ours, theirs);
            return PartialConflictHandler.Resolution.MERGED;
        }
        return null;
    }

    private static void merge(NodeBuilder parent, PropertyState ours, PropertyState theirs) {
        Calendar t;
        Calendar o = ISO8601.parse(ours.getValue(Type.DATE));
        if (o.before(t = ISO8601.parse(theirs.getValue(Type.DATE)))) {
            parent.setProperty("jcr:lastModified", t);
        } else {
            parent.setProperty("jcr:lastModified", o);
        }
    }

    private static boolean isLastModified(PropertyState p) {
        return "jcr:lastModified".equals(p.getName());
    }

    @Override
    public PartialConflictHandler.Resolution deleteDeletedProperty(NodeBuilder parent, PropertyState ours) {
        return null;
    }

    @Override
    public PartialConflictHandler.Resolution deleteChangedProperty(NodeBuilder parent, PropertyState theirs) {
        return null;
    }

    @Override
    public PartialConflictHandler.Resolution addExistingNode(NodeBuilder parent, String name, NodeState ours, NodeState theirs) {
        return null;
    }

    @Override
    public PartialConflictHandler.Resolution changeDeletedNode(NodeBuilder parent, String name, NodeState ours) {
        return null;
    }

    @Override
    public PartialConflictHandler.Resolution deleteChangedNode(NodeBuilder parent, String name, NodeState theirs) {
        return null;
    }

    @Override
    public PartialConflictHandler.Resolution deleteDeletedNode(NodeBuilder parent, String name) {
        return null;
    }
}

