/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.version;

import java.util.Map;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.version.DateVersionSelector;
import org.apache.jackrabbit.core.version.InternalVersion;
import org.apache.jackrabbit.core.version.InternalVersionHistory;
import org.apache.jackrabbit.core.version.VersionSelector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersionSet
implements VersionSelector {
    private final Map<NodeId, InternalVersion> versions;
    private final boolean dateFallback;

    public VersionSet(Map<NodeId, InternalVersion> versions) {
        this(versions, false);
    }

    public VersionSet(Map<NodeId, InternalVersion> versions, boolean dateFallback) {
        this.versions = versions;
        this.dateFallback = dateFallback;
    }

    public Map<NodeId, InternalVersion> versions() {
        return this.versions;
    }

    @Override
    public InternalVersion select(InternalVersionHistory versionHistory) throws RepositoryException {
        InternalVersion v = this.versions.get(versionHistory.getId());
        if (v == null && this.dateFallback) {
            v = DateVersionSelector.selectByDate(versionHistory, null);
        }
        return v;
    }
}

